/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator.specification;

import java.util.Map;
import ma.glasnost.orika.impl.generator.MapEntryRef;
import ma.glasnost.orika.impl.generator.MultiOccurrenceVariableRef;
import ma.glasnost.orika.impl.generator.SourceCodeContext;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.impl.generator.specification.AbstractSpecification;
import ma.glasnost.orika.impl.util.StringUtil;
import ma.glasnost.orika.metadata.FieldMap;
import ma.glasnost.orika.metadata.FieldMapBuilder;
import ma.glasnost.orika.metadata.TypeFactory;

public class MapToMap
extends AbstractSpecification {
    @Override
    public boolean appliesTo(FieldMap fieldMap) {
        return fieldMap.getSource().isMap() && fieldMap.getDestination().isMap();
    }

    @Override
    public String generateMappingCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        MultiOccurrenceVariableRef d = MultiOccurrenceVariableRef.from(destination);
        MultiOccurrenceVariableRef s = MultiOccurrenceVariableRef.from(source);
        if (code.isDebugEnabled()) {
            code.debugField(fieldMap, "mapping from Map<" + source.type().getNestedType(0) + ", " + source.type().getNestedType(1) + "> to Map<" + destination.type().getNestedType(0) + ", " + destination.type().getNestedType(1) + ">");
        }
        StringBuilder out = new StringBuilder();
        out.append(s.ifNotNull());
        out.append("{\n");
        MultiOccurrenceVariableRef newDest = new MultiOccurrenceVariableRef(destination.type(), "new_" + destination.name());
        if (d.isAssignable()) {
            out.append(SourceCodeContext.statement(newDest.declare(d.newMap(), new Object[0]), new Object[0]));
        } else {
            out.append(SourceCodeContext.statement(newDest.declare(d), new Object[0]));
            out.append(SourceCodeContext.statement("%s.clear()", newDest));
        }
        VariableRef newKey = new VariableRef(d.mapKeyType(), "new" + StringUtil.capitalize(d.name()) + "Key");
        VariableRef newVal = new VariableRef(d.mapValueType(), "new" + StringUtil.capitalize(d.name()) + "Val");
        VariableRef entry = new VariableRef(TypeFactory.valueOf(Map.Entry.class), "source" + StringUtil.capitalize(d.name()) + "Entry");
        MapEntryRef sourceKey = new MapEntryRef(s.mapKeyType(), entry.name(), MapEntryRef.EntryPart.KEY);
        MapEntryRef sourceVal = new MapEntryRef(s.mapValueType(), entry.name(), MapEntryRef.EntryPart.VALUE);
        SourceCodeContext.append(out, String.format("for( %s; %s; ) { \n", s.declareIterator(), s.iteratorHasNext()), entry.declare(s.nextElement(), new Object[0]), newKey.declare(), newVal.declare(), code.mapFields(FieldMapBuilder.mapKeys(s.mapKeyType(), d.mapKeyType()), sourceKey, newKey), code.mapFields(FieldMapBuilder.mapValues(s.mapValueType(), d.mapValueType()), sourceVal, newVal), String.format("%s.put(%s, %s)", newDest, newKey, newVal), "\n", "}");
        if (d.isAssignable()) {
            out.append(SourceCodeContext.statement(d.assign(newDest), new Object[0]));
        }
        String mapNull = MapToMap.shouldMapNulls(fieldMap, code) ? String.format(" else {\n %s;\n}", d.assignIfPossible("null", new Object[0])) : "";
        SourceCodeContext.append(out, "}" + mapNull);
        return out.toString();
    }
}

