/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.resource.base;

import java.net.URL;
import java.util.Date;
import net.sf.mmm.util.exception.api.NlsNullPointerException;
import net.sf.mmm.util.resource.api.DataResource;
import net.sf.mmm.util.resource.api.ResourceNotAvailableException;
import net.sf.mmm.util.resource.base.AbstractDataResource;

public class ClasspathResource
extends AbstractDataResource {
    public static final String SCHEME_PREFIX = "classpath:";
    private final String path;
    private final URL url;

    public ClasspathResource(String absoluteClasspath) {
        if (absoluteClasspath == null) {
            throw new NlsNullPointerException("absoluteClasspath");
        }
        if (absoluteClasspath.startsWith("/")) {
            assert (false) : "Classpath '" + absoluteClasspath + "' should NOT contain leading slash!";
            this.path = absoluteClasspath.substring(1);
        } else {
            this.path = absoluteClasspath;
        }
        this.url = Thread.currentThread().getContextClassLoader().getResource(absoluteClasspath);
    }

    public ClasspathResource(Class<?> someClass, String nameOrSuffix, boolean append) {
        this(ClasspathResource.getAbsolutePath(someClass, nameOrSuffix, append));
    }

    public ClasspathResource(Package somePackage, String filename) {
        this(somePackage.getName().replace('.', '/') + '/' + filename);
    }

    @Override
    public String getSchemePrefix() {
        return SCHEME_PREFIX;
    }

    private static String getAbsolutePath(Class<?> someClass, String nameOrSuffix, boolean append) {
        if (append) {
            return someClass.getName().replace('.', '/') + nameOrSuffix;
        }
        return someClass.getPackage().getName().replace('.', '/') + '/' + nameOrSuffix;
    }

    @Override
    public boolean isData() {
        return this.url != null;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public URL getUrl() throws ResourceNotAvailableException {
        if (this.url == null) {
            throw new ResourceNotAvailableException(this.path);
        }
        return this.url;
    }

    @Override
    public Date getLastModificationDate() {
        return null;
    }

    @Override
    public String getUri() {
        return SCHEME_PREFIX + this.path;
    }

    @Override
    public DataResource navigate(String resourcePath) {
        String newPath;
        if (resourcePath.startsWith("/")) {
            newPath = resourcePath.substring(1);
        } else {
            newPath = "";
            int lastSlash = this.path.lastIndexOf(47);
            if (lastSlash > 0) {
                newPath = this.path.substring(0, lastSlash + 1);
            }
            newPath = newPath + resourcePath;
        }
        return new ClasspathResource(newPath);
    }
}

