/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.resource.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import net.sf.mmm.util.filter.api.CharFilter;
import net.sf.mmm.util.lang.api.function.Function;
import net.sf.mmm.util.lang.api.function.VoidFunction;
import net.sf.mmm.util.pattern.base.WildcardGlobPatternCompiler;
import net.sf.mmm.util.resource.api.ResourcePath;
import net.sf.mmm.util.scanner.base.CharSequenceScanner;

public class ResourcePathNode<D>
implements ResourcePath,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final char WINDOWS_DRIVE_LETTER_SUFFIX = ':';
    private static final Function<ResourcePathNode<Void>, Void> VOID_FUNCTION = VoidFunction.getInstance();
    private static final Function<ResourcePathNode<Pattern>, Pattern> GLOB_PATTERN_FUNCTION = new Function<ResourcePathNode<Pattern>, Pattern>(){

        @Override
        public Pattern apply(ResourcePathNode<Pattern> path) {
            return WildcardGlobPatternCompiler.INSTANCE.compile(path.getName());
        }
    };
    public static final ResourcePathNode<Void> ROOT_ABSOLUTE = new ResourcePathRootAbsolute<Void>(VOID_FUNCTION);
    public static final ResourcePathNode<Void> ROOT_RELATIVE = new ResourcePathRootRelative<Void>(VOID_FUNCTION);
    public static final ResourcePathNode<Void> ROOT_HOME = new ResourcePathRootHome<Void>(VOID_FUNCTION);
    private final ResourcePathNode<D> parent;
    private final String name;
    private final D data;

    protected ResourcePathNode(String name, Function<ResourcePathNode<D>, D> dataFunction) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(dataFunction, "dataFunction");
        this.parent = null;
        this.name = name;
        this.data = dataFunction.apply(this);
    }

    protected ResourcePathNode(ResourcePathNode<D> parent, String name, D data) {
        Objects.requireNonNull(parent, "parent");
        Objects.requireNonNull(name, "name");
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name");
        }
        this.parent = parent;
        this.name = name;
        this.data = data;
    }

    protected ResourcePathNode(ResourcePathNode<D> parent, String name, Function<ResourcePathNode<D>, D> dataFunction) {
        Objects.requireNonNull(parent, "parent");
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(dataFunction, "dataFunction");
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name");
        }
        this.parent = parent;
        this.name = name;
        this.data = dataFunction.apply(this);
    }

    @Override
    public ResourcePathNode<D> getParent() {
        return this.parent;
    }

    @Override
    public ResourcePathNode<D> getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public D getData() {
        return this.data;
    }

    @Override
    public boolean isAbsolute() {
        return this.parent.isAbsolute();
    }

    public boolean isParentDirectory() {
        return "..".equals(this.name);
    }

    @Override
    public boolean isRoot() {
        return this.parent == null;
    }

    protected boolean isAppendSeparator() {
        return true;
    }

    public boolean matches(ResourcePathNode<Pattern> patternPath) {
        if (this.isRoot()) {
            if (!patternPath.isRoot()) {
                return false;
            }
        } else {
            if (patternPath.isRoot()) {
                return false;
            }
            if (!this.parent.matches(patternPath.parent)) {
                return false;
            }
        }
        if (patternPath.data == null) {
            return patternPath.name.equals(this.name);
        }
        return ((Pattern)patternPath.data).matcher(this.name).matches();
    }

    public void collectFromRoot(Collection<ResourcePathNode<D>> nodes) {
        if (this.parent != null) {
            this.parent.collectFromRoot(nodes);
        }
        nodes.add(this);
    }

    public List<ResourcePathNode<D>> asList() {
        ArrayList<ResourcePathNode<D>> list = new ArrayList<ResourcePathNode<D>>();
        this.collectFromRoot(list);
        return list;
    }

    public ResourcePathNode<D> navigateTo(ResourcePathNode<D> path) {
        Objects.requireNonNull(path, "path");
        if (path.isAbsolute()) {
            return path;
        }
        return super.navigateFrom(this);
    }

    private ResourcePathNode<D> navigateUp() {
        if (this.parent == null) {
            return this;
        }
        if ("..".equals(this.name)) {
            return this;
        }
        return this.parent;
    }

    private ResourcePathNode<D> navigateFrom(ResourcePathNode<D> resourcePath) {
        if (this.isParentDirectory()) {
            ResourcePathNode<D> result = resourcePath;
            ResourcePathNode<D> segment = this;
            do {
                assert (segment.isParentDirectory());
                if (result.isParentDirectory()) {
                    return new ResourcePathNode<D>(result, segment.name, segment.data);
                }
                result = super.navigateUp();
                segment = segment.parent;
            } while (segment.parent != null);
            return result;
        }
        if (this.parent == null) {
            return resourcePath;
        }
        return new ResourcePathNode<D>(super.navigateFrom(resourcePath), this.name, this.data);
    }

    protected void toString(StringBuilder buffer, char separator) {
        if (this.parent != null) {
            this.parent.toString(buffer, separator);
            if (this.parent.isAppendSeparator()) {
                buffer.append(separator);
            }
        }
        buffer.append(this.name);
    }

    public String toString() {
        return this.toString('/');
    }

    public String toString(char separator) {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer, separator);
        return buffer.toString();
    }

    public static ResourcePathNode<Void> create(String path) {
        return ResourcePathNode.create(path, VOID_FUNCTION);
    }

    public static ResourcePathNode<Pattern> createPattern(String path) {
        return ResourcePathNode.create(path, GLOB_PATTERN_FUNCTION);
    }

    public static <D> ResourcePathNode<D> create(String path, Function<ResourcePathNode<D>, D> dataFunction) {
        if (path == null) {
            return null;
        }
        if (path.isEmpty()) {
            if (dataFunction == VOID_FUNCTION) {
                return ROOT_RELATIVE;
            }
            return new ResourcePathRootRelative(dataFunction);
        }
        char[] chars = path.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '\\') continue;
            chars[i] = 47;
        }
        CharSequenceScanner scanner = new CharSequenceScanner(chars);
        ResourcePathNode<D> result = ResourcePathNode.createRootPathSegment(scanner, path, dataFunction);
        while (scanner.hasNext()) {
            String segment = scanner.readUntil('/', true);
            if (segment.length() <= 0 || ".".equals(segment)) continue;
            if ("..".equals(segment)) {
                if (result.isRoot()) {
                    if (result.isAbsolute() && !(result instanceof ResourcePathRootHome)) continue;
                    result = new ResourcePathNode<D>(result, segment, dataFunction);
                    continue;
                }
                if ("..".equals(result.getName())) {
                    result = new ResourcePathNode<D>(result, segment, dataFunction);
                    continue;
                }
                result = result.parent;
                continue;
            }
            result = new ResourcePathNode<D>(result, segment, dataFunction);
        }
        return result;
    }

    private static <D> ResourcePathNode<D> createRootPathSegment(CharSequenceScanner scanner, String originalPath, Function<ResourcePathNode<D>, D> dataFunction) {
        int length;
        char first = scanner.peek();
        if (first == '/') {
            if (originalPath.startsWith("\\\\")) {
                scanner.setCurrentIndex("\\\\".length());
                String uncSegment = scanner.readUntil(CharFilter.FILE_SEPARATOR_FILTER, true);
                return new ResourcePathRootUnc<D>(uncSegment, dataFunction);
            }
            if (dataFunction == VOID_FUNCTION) {
                return ROOT_ABSOLUTE;
            }
            return new ResourcePathRootAbsolute(dataFunction);
        }
        if (first == '~') {
            scanner.setCurrentIndex(1);
            String user = scanner.readUntil('/', true);
            if (user.isEmpty()) {
                if (dataFunction == VOID_FUNCTION) {
                    return ROOT_HOME;
                }
                return new ResourcePathRootHome<D>(dataFunction);
            }
            return new ResourcePathRootHome<D>(user, dataFunction);
        }
        if (CharFilter.ASCII_LETTER_FILTER.accept(first) && (length = scanner.getLength()) > 1 && scanner.charAt(1) == ':' && (length == 2 || scanner.charAt(2) == '/')) {
            scanner.setCurrentIndex(2);
            return new ResourcePathRootWindows<D>(originalPath.substring(0, 1), dataFunction);
        }
        int authorityIndex = originalPath.indexOf("://");
        if (authorityIndex > 0) {
            String scheme = scanner.read(authorityIndex);
            scanner.require("://", false);
            String authority = scanner.readUntil('/', true);
            return new ResourcePathRootUrl<D>(scheme, authority, dataFunction);
        }
        if (dataFunction == VOID_FUNCTION) {
            return ROOT_RELATIVE;
        }
        return new ResourcePathRootRelative(dataFunction);
    }

    public static class ResourcePathRootUrl<D>
    extends ResourcePathNode<D> {
        private static final long serialVersionUID = 1L;
        private final String scheme;
        private final String authority;

        public ResourcePathRootUrl(String scheme, String authority, Function<ResourcePathNode<D>, D> dataFunction) {
            super(scheme + "://" + authority, dataFunction);
            this.scheme = scheme;
            this.authority = authority;
        }

        public String getScheme() {
            return this.scheme;
        }

        public String getAuthority() {
            return this.authority;
        }

        @Override
        public boolean isAbsolute() {
            return true;
        }
    }

    public static class ResourcePathRootUnc<D>
    extends ResourcePathNode<D> {
        private static final long serialVersionUID = 1L;

        public ResourcePathRootUnc(String uncAuthority, Function<ResourcePathNode<D>, D> dataFunction) {
            super("\\\\" + uncAuthority, dataFunction);
        }

        @Override
        public boolean isAbsolute() {
            return true;
        }
    }

    public static class ResourcePathRootHome<D>
    extends ResourcePathNode<D> {
        private static final long serialVersionUID = 1L;

        public ResourcePathRootHome(Function<ResourcePathNode<D>, D> dataFunction) {
            this("", dataFunction);
        }

        public ResourcePathRootHome(String user, Function<ResourcePathNode<D>, D> dataFunction) {
            super('~' + user, dataFunction);
        }

        @Override
        public boolean isAbsolute() {
            return true;
        }
    }

    public static final class ResourcePathRootRelative<D>
    extends ResourcePathNode<D> {
        private static final long serialVersionUID = 1L;

        private ResourcePathRootRelative(Function<ResourcePathNode<D>, D> dataFunction) {
            super("", dataFunction);
        }

        @Override
        public boolean isAbsolute() {
            return false;
        }

        @Override
        protected boolean isAppendSeparator() {
            return false;
        }
    }

    public static class ResourcePathRootWindows<D>
    extends ResourcePathNode<D> {
        private static final long serialVersionUID = 1L;

        public ResourcePathRootWindows(String drive, Function<ResourcePathNode<D>, D> dataFunction) {
            super(drive + ':', dataFunction);
        }

        @Override
        public boolean isAbsolute() {
            return true;
        }
    }

    public static final class ResourcePathRootAbsolute<D>
    extends ResourcePathNode<D> {
        private static final long serialVersionUID = 1L;

        private ResourcePathRootAbsolute(Function<ResourcePathNode<D>, D> dataFunction) {
            super(ResourcePath.PATH_SEGMENT_SEPARATOR, dataFunction);
        }

        @Override
        public boolean isAbsolute() {
            return true;
        }

        @Override
        protected boolean isAppendSeparator() {
            return false;
        }
    }
}

