/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.reflect.base;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import javax.inject.Inject;
import net.sf.mmm.util.component.api.AlreadyInitializedException;
import net.sf.mmm.util.component.base.AbstractLoggableComponent;
import net.sf.mmm.util.reflect.api.AnnotationNotForTargetException;
import net.sf.mmm.util.reflect.api.AnnotationNotRuntimeException;
import net.sf.mmm.util.reflect.api.AnnotationUtil;
import net.sf.mmm.util.reflect.api.ReflectionUtil;
import net.sf.mmm.util.reflect.base.ReflectionUtilImpl;

public class AnnotationUtilImpl
extends AbstractLoggableComponent
implements AnnotationUtil {
    private static AnnotationUtilImpl instance;
    private ReflectionUtil reflectionUtil;

    @Override
    protected void doInitialized() {
        super.doInitialized();
        if (instance == null) {
            instance = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AnnotationUtilImpl getInstance() {
        if (instance != null) return instance;
        Class<AnnotationUtilImpl> clazz = AnnotationUtilImpl.class;
        synchronized (AnnotationUtilImpl.class) {
            if (instance != null) return instance;
            AnnotationUtilImpl util = new AnnotationUtilImpl();
            util.setReflectionUtil(ReflectionUtilImpl.getInstance());
            instance = util;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected ReflectionUtil getReflectionUtil() {
        return this.reflectionUtil;
    }

    @Inject
    public void setReflectionUtil(ReflectionUtil reflectionUtil) {
        if (this.reflectionUtil != null) {
            throw new AlreadyInitializedException();
        }
        this.reflectionUtil = reflectionUtil;
    }

    @Override
    public <A extends Annotation> boolean isRuntimeAnnotation(Class<A> annotationType) {
        Retention retention = annotationType.getAnnotation(Retention.class);
        if (retention != null) {
            return retention.value() == RetentionPolicy.RUNTIME;
        }
        return false;
    }

    @Override
    public <A extends Annotation> boolean isAnnotationForType(Class<A> annotationType, ElementType targetType) {
        Target target = annotationType.getAnnotation(Target.class);
        if (target != null) {
            ElementType[] types = target.value();
            for (int i = 0; i < types.length; ++i) {
                if (types[i] != targetType) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public <A extends Annotation> A getClassAnnotation(Class<?> annotatedClass, Class<A> annotation) throws IllegalArgumentException {
        if (!this.isRuntimeAnnotation(annotation)) {
            throw new AnnotationNotRuntimeException(annotation);
        }
        if (!this.isAnnotationForType(annotation, ElementType.TYPE)) {
            throw new AnnotationNotForTargetException(annotation, ElementType.TYPE);
        }
        A result = annotatedClass.getAnnotation(annotation);
        Class<?> currentClass = annotatedClass;
        while (result == null) {
            if ((currentClass = currentClass.getSuperclass()) == null) {
                return null;
            }
            result = currentClass.getAnnotation(annotation);
        }
        return result;
    }

    private <A extends Annotation> A getInterfacesAnnotation(Class<?> annotatedType, Class<A> annotation) {
        A result;
        int i;
        Class<?>[] interfaces = annotatedType.getInterfaces();
        for (i = 0; i < interfaces.length; ++i) {
            result = interfaces[i].getAnnotation(annotation);
            if (result == null) continue;
            return result;
        }
        for (i = 0; i < interfaces.length; ++i) {
            result = this.getInterfacesAnnotation(interfaces[i], annotation);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public <A extends Annotation> A getTypeAnnotation(Class<?> annotatedType, Class<A> annotation) {
        A result = this.getClassAnnotation(annotatedType, annotation);
        Class<?> currentClass = annotatedType;
        while (result == null) {
            result = this.getInterfacesAnnotation(currentClass, annotation);
            if ((currentClass = currentClass.getSuperclass()) != null) continue;
            break;
        }
        return result;
    }

    @Override
    public <A extends Annotation> A getMethodAnnotation(Method annotatedMethod, Class<A> annotation) {
        if (!this.isRuntimeAnnotation(annotation)) {
            throw new AnnotationNotRuntimeException(annotation);
        }
        if (!this.isAnnotationForType(annotation, ElementType.METHOD)) {
            throw new AnnotationNotForTargetException(annotation, ElementType.METHOD);
        }
        A result = annotatedMethod.getAnnotation(annotation);
        if (result == null) {
            String methodName = annotatedMethod.getName();
            Class<?>[] parameterTypes = annotatedMethod.getParameterTypes();
            Class<?> inheritingClass = annotatedMethod.getDeclaringClass();
            while (result == null) {
                Method currentMethod = this.getReflectionUtil().getParentMethod(inheritingClass, methodName, parameterTypes);
                if (currentMethod == null) {
                    return null;
                }
                result = currentMethod.getAnnotation(annotation);
                inheritingClass = currentMethod.getDeclaringClass();
            }
        }
        return result;
    }
}

