/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.nls.impl.formatter;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import net.sf.mmm.util.io.api.IoMode;
import net.sf.mmm.util.io.api.RuntimeIoException;
import net.sf.mmm.util.lang.api.Visitor;
import net.sf.mmm.util.nls.api.NlsTemplateResolver;
import net.sf.mmm.util.nls.base.AbstractNlsFormatterPlugin;
import net.sf.mmm.util.reflect.api.ReflectionUtil;
import net.sf.mmm.util.reflect.base.ReflectionUtilImpl;

public class NlsFormatterType
extends AbstractNlsFormatterPlugin<Object> {
    private static final Package PACKAGE_JAVA_LANG = Package.class.getPackage();
    private final String style;
    private ReflectionUtil reflectionUtil;

    public NlsFormatterType(String style) {
        this.style = style;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public String getType() {
        return "type";
    }

    protected ReflectionUtil getReflectionUtil() {
        return this.reflectionUtil;
    }

    @Inject
    public void setReflectionUtil(ReflectionUtil reflectionUtil) {
        this.getInitializationState().requireNotInitilized();
        this.reflectionUtil = reflectionUtil;
    }

    @Override
    protected void doInitialize() {
        super.doInitialize();
        if (this.reflectionUtil == null) {
            this.reflectionUtil = ReflectionUtilImpl.getInstance();
        }
    }

    @Override
    public void format(Object object, Locale locale, Map<String, Object> arguments, NlsTemplateResolver resolver, Appendable buffer) throws IOException {
        if (object == null) {
            buffer.append("null");
        } else if (object instanceof Type) {
            Type type = (Type)object;
            if ("short".equals(this.style)) {
                Class<?> rawType = this.reflectionUtil.createGenericType(type).getAssignmentClass();
                buffer.append(rawType.getSimpleName());
            } else if ("medium".equals(this.style)) {
                Class<?> rawType = this.reflectionUtil.createGenericType(type).getAssignmentClass();
                if (PACKAGE_JAVA_LANG.equals(rawType.getPackage())) {
                    buffer.append(rawType.getSimpleName());
                } else {
                    buffer.append(rawType.getCanonicalName());
                }
            } else {
                ClassFormatter formatter = new ClassFormatter(buffer);
                this.reflectionUtil.toString(type, buffer, formatter);
            }
        } else {
            buffer.append(object.toString());
        }
    }

    private class ClassFormatter
    implements Visitor<Class<?>> {
        private final Appendable buffer;

        public ClassFormatter(Appendable buffer) {
            this.buffer = buffer;
        }

        @Override
        public void visit(Class<?> value) {
            try {
                if ("long".equals(NlsFormatterType.this.style)) {
                    if (PACKAGE_JAVA_LANG.equals(value.getPackage())) {
                        this.buffer.append(value.getSimpleName());
                    } else {
                        this.buffer.append(value.getCanonicalName());
                    }
                } else {
                    this.buffer.append(value.getCanonicalName());
                }
            }
            catch (IOException e) {
                throw new RuntimeIoException((Throwable)e, IoMode.WRITE);
            }
        }
    }
}

