/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.nls.base;

import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.mmm.util.collection.api.MapFactory;
import net.sf.mmm.util.collection.base.ConcurrentHashMapFactory;
import net.sf.mmm.util.nls.api.NlsAccess;
import net.sf.mmm.util.nls.api.NlsLocalizer;
import net.sf.mmm.util.nls.api.NlsMessage;
import net.sf.mmm.util.nls.api.NlsMessageFactory;
import net.sf.mmm.util.nls.api.NlsTemplate;
import net.sf.mmm.util.nls.api.NlsTemplateResolver;
import net.sf.mmm.util.nls.base.NlsTemplateImpl;

public class NlsCachingLocalizer
implements NlsLocalizer {
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("\\{(([^}]*)[#])?([^}]*)\\}");
    private final NlsMessageFactory messageFactory;
    private final NlsTemplateResolver templateResolver;
    private final Map<String, NlsMessage> messagesMap;
    private final Map<String, NlsTemplate> templatesMap;
    private final String bundleName;

    public NlsCachingLocalizer(String bundleName) {
        this(bundleName, NlsAccess.getFactory(), NlsAccess.getTemplateResolver());
    }

    public NlsCachingLocalizer(String bundleName, NlsMessageFactory messageFactory, NlsTemplateResolver templateResolver) {
        this(bundleName, messageFactory, templateResolver, ConcurrentHashMapFactory.INSTANCE);
    }

    public NlsCachingLocalizer(String bundleName, NlsMessageFactory messageFactory, NlsTemplateResolver templateResolver, MapFactory<? extends Map> mapFactory) {
        this.bundleName = bundleName;
        this.messageFactory = messageFactory;
        this.templateResolver = templateResolver;
        this.messagesMap = mapFactory.create();
        this.templatesMap = mapFactory.create();
    }

    protected NlsTemplate parseTemplate(String internationalizedMessage) {
        Matcher matcher = TEMPLATE_PATTERN.matcher(internationalizedMessage);
        if (matcher.matches()) {
            String name = matcher.group(2);
            if (name == null) {
                name = this.bundleName;
            }
            String key = matcher.group(3);
            return new NlsTemplateImpl(name, key);
        }
        return null;
    }

    @Override
    public String localize(Locale locale, String internationalizedMessage, Map<String, Object> arguments) {
        NlsTemplate template = this.templatesMap.get(internationalizedMessage);
        if (template == null) {
            template = this.parseTemplate(internationalizedMessage);
            if (template == null) {
                template = this.templateResolver.resolveTemplate(internationalizedMessage);
            }
            this.templatesMap.put(internationalizedMessage, template);
        }
        NlsMessage message = this.messageFactory.create(template, arguments);
        return message.getLocalizedMessage(locale);
    }

    @Override
    public String localize(Locale locale, String internationalizedMessage) {
        NlsMessage message = this.messagesMap.get(internationalizedMessage);
        if (message == null) {
            NlsTemplate template = this.parseTemplate(internationalizedMessage);
            message = template == null ? this.messageFactory.create(internationalizedMessage) : this.messageFactory.create(template);
            this.messagesMap.put(internationalizedMessage, message);
        }
        return message.getLocalizedMessage(locale, this.templateResolver);
    }
}

