/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.nls.base;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.inject.Named;
import net.sf.mmm.util.component.base.AbstractLoggableObject;
import net.sf.mmm.util.exception.api.NlsIllegalArgumentException;
import net.sf.mmm.util.nls.api.NlsBundle;
import net.sf.mmm.util.nls.api.NlsBundleKey;
import net.sf.mmm.util.nls.api.NlsBundleMessage;
import net.sf.mmm.util.nls.api.NlsMessage;
import net.sf.mmm.util.nls.base.GenericResourceBundle;
import net.sf.mmm.util.nls.base.NlsArgumentDescriptor;
import net.sf.mmm.util.nls.base.NlsMessageDescriptor;
import net.sf.mmm.util.nls.base.ResourceBundleControlUtf8WithNlsBundleSupport;
import net.sf.mmm.util.reflect.api.ClassName;

public class NlsBundleHelper
extends AbstractLoggableObject {
    public static final NlsBundleHelper INSTANCE = new NlsBundleHelper();

    public static NlsBundleHelper getInstance() {
        return INSTANCE;
    }

    public ClassName getQualifiedLocation(Class<? extends NlsBundle> nlsBundleInterface) {
        String simpleName = nlsBundleInterface.getSimpleName();
        if (simpleName.endsWith("Root")) {
            simpleName = simpleName.substring(0, simpleName.length() - "Root".length());
        } else {
            this.getLogger().error("Illegal NlsBundle interface '" + nlsBundleInterface.getName() + "': has to end with the suffix '" + "Root" + "'.");
        }
        return new ClassName(nlsBundleInterface.getPackage().getName(), simpleName);
    }

    public String getKey(Method method) {
        NlsBundleKey keyAnnotation = method.getAnnotation(NlsBundleKey.class);
        String key = keyAnnotation == null ? method.getName() : keyAnnotation.value();
        return key;
    }

    public ResourceBundle getResourceBundle(String qualifiedBundleName, Locale locale) {
        return ResourceBundle.getBundle(qualifiedBundleName, locale, ResourceBundleControlUtf8WithNlsBundleSupport.INSTANCE);
    }

    public String getMessage(Method method) {
        NlsBundleMessage messageAnnotation = method.getAnnotation(NlsBundleMessage.class);
        if (messageAnnotation != null) {
            return messageAnnotation.value();
        }
        return null;
    }

    public NlsMessageDescriptor getDescriptor(Method method) {
        return new NlsMessageDescriptor(method);
    }

    public NlsArgumentDescriptor[] getArguments(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0) {
            return NlsArgumentDescriptor.EMPTY_ARRAY;
        }
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        NlsArgumentDescriptor[] arguments = new NlsArgumentDescriptor[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            NlsArgumentDescriptor arg;
            String name = this.getName(parameterAnnotations[i], i);
            arguments[i] = arg = new NlsArgumentDescriptor(name, parameterTypes[i], i);
        }
        return arguments;
    }

    private String getName(Annotation[] annotations, int i) {
        for (Annotation currentAnnotation : annotations) {
            if (!(currentAnnotation instanceof Named)) continue;
            Named namedAnnotation = (Named)currentAnnotation;
            return namedAnnotation.value();
        }
        return Integer.toString(i);
    }

    public ResourceBundle toResourceBundle(Class<? extends NlsBundle> bundleClass) {
        Hashtable<String, String> bundleProperties = new Hashtable<String, String>();
        for (Method method : bundleClass.getMethods()) {
            if (!this.isNlsBundleMethod(method, false)) continue;
            String key = this.getKey(method);
            String message = this.getMessage(method);
            bundleProperties.put(key, message);
        }
        GenericResourceBundle bundle = new GenericResourceBundle(bundleProperties);
        return bundle;
    }

    public boolean isNlsBundleMethod(Method method, boolean ignoreIllegalMethods) {
        Class<NlsBundle> declaringClass = method.getDeclaringClass();
        assert (declaringClass.isInterface());
        if (NlsMessage.class.equals(method.getReturnType())) {
            assert (NlsBundle.class.isAssignableFrom(declaringClass));
            return true;
        }
        if (!declaringClass.isAssignableFrom(NlsBundle.class) && !ignoreIllegalMethods) {
            throw new NlsIllegalArgumentException((Object)(declaringClass.getName() + "." + method.getName()));
        }
        return false;
    }
}

