/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.nls.base;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public abstract class AbstractResourceBundle
extends ResourceBundle {
    private static final String PREFIX_INTERNAL_FIELD = "INT_";
    private Hashtable<String, Object> bundle;
    private Map<Object, String> reverse;

    public AbstractResourceBundle() {
        try {
            Field[] fields = this.getClass().getFields();
            this.bundle = new Hashtable(fields.length);
            this.reverse = new HashMap<Object, String>(fields.length);
            for (int i = 0; i < fields.length; ++i) {
                String key;
                int modifiers = fields[i].getModifiers();
                if (!Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers) || Modifier.isPrivate(modifiers) || fields[i].getType() != String.class || (key = fields[i].getName()).startsWith(PREFIX_INTERNAL_FIELD)) continue;
                Object value = fields[i].get(null);
                this.bundle.put(key, value);
                this.reverse.put(value, key);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to initialize " + this.getClass().getName(), e);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Failed to initialize " + this.getClass().getName(), e);
        }
    }

    public String getKey(Object object) {
        return this.reverse.get(object);
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.bundle.keys();
    }

    @Override
    public boolean containsKey(String key) {
        return this.bundle.containsKey(key);
    }

    @Override
    public Set<String> keySet() {
        return this.bundle.keySet();
    }

    @Override
    protected Object handleGetObject(String key) {
        return this.bundle.get(key);
    }
}

