/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.nls.base;

import java.lang.reflect.Type;
import javax.inject.Inject;
import net.sf.mmm.util.component.base.AbstractLoggableComponent;
import net.sf.mmm.util.exception.api.NlsParseException;
import net.sf.mmm.util.filter.api.CharFilter;
import net.sf.mmm.util.filter.base.ListCharFilter;
import net.sf.mmm.util.nls.api.NlsArgument;
import net.sf.mmm.util.nls.api.NlsArgumentParser;
import net.sf.mmm.util.nls.api.NlsFormatter;
import net.sf.mmm.util.nls.api.NlsFormatterManager;
import net.sf.mmm.util.nls.api.NlsFormatterPlugin;
import net.sf.mmm.util.nls.impl.formatter.NlsFormatterManagerImpl;
import net.sf.mmm.util.scanner.base.CharSequenceScanner;
import net.sf.mmm.util.text.api.Justification;
import net.sf.mmm.util.text.api.JustificationBuilder;
import net.sf.mmm.util.text.base.JustificationBuilderImpl;

public abstract class AbstractNlsFormatterManager
extends AbstractLoggableComponent
implements NlsFormatterManager,
NlsArgumentParser {
    protected static final CharFilter NO_COMMA_OR_END_EXPRESSION = new ListCharFilter(false, ',', '}');
    protected static final CharFilter NO_EXPRESSION = new ListCharFilter(false, '{', '}');
    private static AbstractNlsFormatterManager instance;
    private JustificationBuilder justificationBuilder;

    public static AbstractNlsFormatterManager getInstance() {
        if (instance == null) {
            new NlsFormatterManagerImpl().initialize();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doInitialized() {
        super.doInitialized();
        Class<AbstractNlsFormatterManager> clazz = AbstractNlsFormatterManager.class;
        synchronized (AbstractNlsFormatterManager.class) {
            if (instance == null) {
                instance = this;
            } else if (instance != this) {
                this.getLogger().warn("Duplicate instances {} and {} (getInstance() vs. IoC)", (Object)instance, (Object)this);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public NlsArgument parse(CharSequenceScanner scanner) {
        String key = scanner.readWhile(CharFilter.IDENTIFIER_FILTER);
        char c = scanner.next();
        int index = scanner.getCurrentIndex();
        String formatType = null;
        NlsFormatterPlugin<?> formatter = null;
        if (c == ',') {
            formatType = scanner.readWhile(NO_COMMA_OR_END_EXPRESSION);
            index = scanner.getCurrentIndex();
            c = scanner.forceNext();
            if (c == ',') {
                index = scanner.getCurrentIndex();
                try {
                    formatter = this.getSubFormatter(formatType, scanner);
                }
                catch (Exception e) {
                    Class<NlsFormatter> type = NlsFormatter.class;
                    throw new NlsParseException((Throwable)e, (Object)scanner.substring(index, scanner.getCurrentIndex()), (Type)((Object)type));
                }
                c = scanner.forceNext();
            } else {
                formatter = this.getFormatter(formatType);
            }
        }
        Justification justification = null;
        if (c == '{') {
            String formatJustification = scanner.readUntil('}', false);
            justification = this.getJustificationBuilder().build(formatJustification);
            c = scanner.forceNext();
        }
        if (c != '}') {
            throw new NlsParseException((CharSequence)scanner.substring(index, scanner.getCurrentIndex()), (CharSequence)"}");
        }
        if (formatter == null) {
            formatter = this.getFormatter();
        }
        return new NlsArgument(key, formatter, justification);
    }

    protected NlsFormatterPlugin<?> getSubFormatter(String formatType, CharSequenceScanner scanner) {
        String formatStyle = scanner.readWhile(NO_EXPRESSION);
        return this.getFormatter(formatType, formatStyle);
    }

    @Override
    protected void doInitialize() {
        super.doInitialize();
        if (this.justificationBuilder == null) {
            this.justificationBuilder = JustificationBuilderImpl.getInstance();
        }
    }

    protected JustificationBuilder getJustificationBuilder() {
        return this.justificationBuilder;
    }

    @Inject
    public void setJustificationBuilder(JustificationBuilder justificationBuilder) {
        this.getInitializationState().requireNotInitilized();
        this.justificationBuilder = justificationBuilder;
    }

    public NlsFormatterPlugin<Object> getFormatter() {
        return this.getFormatter(null);
    }

    public NlsFormatterPlugin<?> getFormatter(String formatType) {
        return this.getFormatter(formatType, null);
    }
}

