/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.base.datatype.descriptor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import net.sf.mmm.util.exception.api.IllegalCaseException;
import net.sf.mmm.util.lang.api.SimpleDatatype;
import net.sf.mmm.util.lang.base.datatype.descriptor.AbstractDatatypeDescriptor;
import net.sf.mmm.util.lang.base.datatype.descriptor.DatatypeSegmentDescriptorSimpleDatatype;
import net.sf.mmm.util.reflect.api.AccessFailedException;
import net.sf.mmm.util.reflect.api.InstantiationFailedException;
import net.sf.mmm.util.reflect.api.InvocationFailedException;
import net.sf.mmm.util.reflect.api.ReflectionUtil;

public class DatatypeDescriptorSimpleDatatype<T extends SimpleDatatype<?>>
extends AbstractDatatypeDescriptor<T> {
    private final Constructor<T> constructor;

    public DatatypeDescriptorSimpleDatatype(Class<T> datatype, ReflectionUtil reflectionUtil) {
        super(datatype, DatatypeSegmentDescriptorSimpleDatatype.newInstance(datatype, reflectionUtil));
        if (datatype.isEnum()) {
            this.constructor = null;
        } else {
            assert (!datatype.isInterface());
            assert (!Modifier.isAbstract(datatype.getModifiers()));
            Class<?> type = this.getSegmentDescriptors().get(0).getType();
            try {
                this.constructor = datatype.getConstructor(type);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid SimpleDatatype '" + datatype.getName() + "' - has to be an Enum or non-abstract class with constructor compatible to getValue()!");
            }
        }
    }

    @Override
    protected T doCreate(Object ... segments) {
        if (this.constructor == null) {
            Object value = segments[0];
            if (value == null) {
                return null;
            }
            for (SimpleDatatype instance : (SimpleDatatype[])this.getDatatype().getEnumConstants()) {
                if (!instance.getValue().equals(value)) continue;
                return (T)instance;
            }
            throw new IllegalCaseException(value.toString() + "@" + this.getDatatype().getName());
        }
        try {
            return (T)((SimpleDatatype)this.constructor.newInstance(segments));
        }
        catch (IllegalArgumentException | InstantiationException e) {
            throw new InstantiationFailedException((Throwable)e, this.getDatatype());
        }
        catch (IllegalAccessException e) {
            throw new AccessFailedException((Throwable)e, this.constructor);
        }
        catch (InvocationTargetException e) {
            throw new InvocationFailedException((Throwable)e, this.constructor);
        }
    }
}

