/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.base.datatype.adapter.jackson;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import javax.inject.Inject;
import net.sf.mmm.util.component.base.AbstractLoggableComponent;
import net.sf.mmm.util.lang.api.DatatypeDescriptorManager;
import net.sf.mmm.util.lang.api.DatatypeDetector;
import net.sf.mmm.util.lang.api.EnumProvider;
import net.sf.mmm.util.lang.base.datatype.adapter.jackson.DatatypeJsonDeserializers;
import net.sf.mmm.util.lang.base.datatype.adapter.jackson.DatatypeJsonSerializers;

public class DatatypeObjectMapperFactory
extends AbstractLoggableComponent {
    private DatatypeDescriptorManager datatypeDescriptorManager;
    private DatatypeDetector datatypeDetector;
    private EnumProvider enumProvider;

    @Inject
    public void setDatatypeDescriptorManager(DatatypeDescriptorManager datatypeDescriptorManager) {
        this.datatypeDescriptorManager = datatypeDescriptorManager;
    }

    @Inject
    public void setDatatypeDetector(DatatypeDetector datatypeDetector) {
        this.datatypeDetector = datatypeDetector;
    }

    @Inject
    public void setEnumProvider(EnumProvider enumProvider) {
        this.enumProvider = enumProvider;
    }

    public ObjectMapper create() {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule("DatatypeAdapter", new Version(6, 0, 0, null, "net.sf.mmm", "mmm-util-core"));
        DatatypeJsonSerializers serializers = new DatatypeJsonSerializers();
        serializers.setDatatypeDescriptorManager(this.datatypeDescriptorManager);
        serializers.setDatatypeDetector(this.datatypeDetector);
        module.setSerializers((SimpleSerializers)serializers);
        DatatypeJsonDeserializers deserializers = new DatatypeJsonDeserializers();
        deserializers.setDatatypeDescriptorManager(this.datatypeDescriptorManager);
        deserializers.setDatatypeDetector(this.datatypeDetector);
        deserializers.setEnumProvider(this.enumProvider);
        module.setDeserializers((SimpleDeserializers)deserializers);
        mapper.registerModule((Module)module);
        return mapper;
    }
}

