/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.base;

import net.sf.mmm.util.lang.api.AbstractEqualsChecker;
import net.sf.mmm.util.lang.api.EqualsChecker;

public class EqualsCheckerArray
extends AbstractEqualsChecker<Object> {
    private static final long serialVersionUID = 1L;
    private final EqualsChecker<Object> delegate;

    public EqualsCheckerArray(EqualsChecker<Object> delegate) {
        this.delegate = delegate;
    }

    @Override
    protected boolean isEqualNotNull(Object value1, Object value2) {
        Class<?> class1 = value1.getClass();
        if (class1.isArray()) {
            Class<?> class2 = value2.getClass();
            if (!class1.equals(class2)) {
                return false;
            }
            if (value1 instanceof Object[]) {
                if (value2 instanceof Object[]) {
                    Object[] array1 = (Object[])value1;
                    Object[] array2 = (Object[])value2;
                    if (array1.length != array2.length) {
                        return false;
                    }
                    for (int i = 0; i < array1.length; ++i) {
                        if (this.isEqual(array1[i], array2[i])) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return this.isEqualPrimitiveArray(value1, value2);
        }
        return this.delegate.isEqual(value1, value2);
    }

    protected boolean isEqualPrimitiveArray(Object value1, Object value2) {
        if (value1 instanceof int[]) {
            if (value2 instanceof int[]) {
                int[] array1 = (int[])value1;
                int[] array2 = (int[])value2;
                if (array1.length != array2.length) {
                    return false;
                }
                for (int i = 0; i < array1.length; ++i) {
                    if (array1[i] == array2[i]) continue;
                    return false;
                }
                return true;
            }
        } else if (value1 instanceof long[]) {
            if (value2 instanceof long[]) {
                long[] array1 = (long[])value1;
                long[] array2 = (long[])value2;
                if (array1.length != array2.length) {
                    return false;
                }
                for (int i = 0; i < array1.length; ++i) {
                    if (array1[i] == array2[i]) continue;
                    return false;
                }
                return true;
            }
        } else if (value1 instanceof double[]) {
            if (value2 instanceof double[]) {
                double[] array1 = (double[])value1;
                double[] array2 = (double[])value2;
                if (array1.length != array2.length) {
                    return false;
                }
                for (int i = 0; i < array1.length; ++i) {
                    if (array1[i] == array2[i]) continue;
                    return false;
                }
                return true;
            }
        } else if (value1 instanceof boolean[]) {
            if (value2 instanceof boolean[]) {
                boolean[] array1 = (boolean[])value1;
                boolean[] array2 = (boolean[])value2;
                if (array1.length != array2.length) {
                    return false;
                }
                for (int i = 0; i < array1.length; ++i) {
                    if (array1[i] == array2[i]) continue;
                    return false;
                }
                return true;
            }
        } else if (value1 instanceof char[]) {
            if (value2 instanceof char[]) {
                char[] array1 = (char[])value1;
                char[] array2 = (char[])value2;
                if (array1.length != array2.length) {
                    return false;
                }
                for (int i = 0; i < array1.length; ++i) {
                    if (array1[i] == array2[i]) continue;
                    return false;
                }
                return true;
            }
        } else if (value1 instanceof float[]) {
            if (value2 instanceof float[]) {
                float[] array1 = (float[])value1;
                float[] array2 = (float[])value2;
                if (array1.length != array2.length) {
                    return false;
                }
                for (int i = 0; i < array1.length; ++i) {
                    if (array1[i] == array2[i]) continue;
                    return false;
                }
                return true;
            }
        } else if (value1 instanceof short[]) {
            if (value2 instanceof short[]) {
                short[] array1 = (short[])value1;
                short[] array2 = (short[])value2;
                if (array1.length != array2.length) {
                    return false;
                }
                for (int i = 0; i < array1.length; ++i) {
                    if (array1[i] == array2[i]) continue;
                    return false;
                }
                return true;
            }
        } else if (value1 instanceof byte[] && value2 instanceof byte[]) {
            byte[] array1 = (byte[])value1;
            byte[] array2 = (byte[])value2;
            if (array1.length != array2.length) {
                return false;
            }
            for (int i = 0; i < array1.length; ++i) {
                if (array1[i] == array2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

