/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.api;

import net.sf.mmm.util.lang.api.EnumType;

public enum Conjunction implements EnumType<String>
{
    AND("&&", "and"){

        @Override
        public boolean evalEmpty() {
            return true;
        }

        @Override
        public Boolean evalSingle(boolean argument) {
            if (!argument) {
                return Boolean.FALSE;
            }
            return null;
        }

        @Override
        public Conjunction negate() {
            return NAND;
        }
    }
    ,
    OR("||", "or"){

        @Override
        public boolean evalEmpty() {
            return false;
        }

        @Override
        public Boolean evalSingle(boolean argument) {
            if (argument) {
                return Boolean.TRUE;
            }
            return null;
        }

        @Override
        public Conjunction negate() {
            return NOR;
        }
    }
    ,
    NAND("!&", "nand"){

        @Override
        public boolean evalEmpty() {
            return false;
        }

        @Override
        public Boolean evalSingle(boolean argument) {
            if (!argument) {
                return Boolean.TRUE;
            }
            return null;
        }

        @Override
        public Conjunction negate() {
            return AND;
        }
    }
    ,
    NOR("!|", "nor"){

        @Override
        public boolean evalEmpty() {
            return true;
        }

        @Override
        public Boolean evalSingle(boolean argument) {
            if (argument) {
                return Boolean.FALSE;
            }
            return null;
        }

        @Override
        public Conjunction negate() {
            return OR;
        }
    };

    private final String value;
    private final String title;

    private Conjunction(String value, String title) {
        this.value = value;
        this.title = title;
    }

    public final boolean eval(boolean ... arguments) {
        for (boolean b : arguments) {
            Boolean single = this.evalSingle(b);
            if (single == null) continue;
            return single;
        }
        return this.evalEmpty();
    }

    public abstract Boolean evalSingle(boolean var1);

    public abstract boolean evalEmpty();

    @Override
    public String getValue() {
        return this.value;
    }

    public boolean isNegation() {
        return this == NOR || this == NAND;
    }

    public abstract Conjunction negate();

    @Override
    public String toString() {
        return this.title;
    }

    public static Conjunction fromValue(String value) {
        for (Conjunction alignment : Conjunction.values()) {
            if (!alignment.value.equals(value)) continue;
            return alignment;
        }
        return null;
    }
}

