/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.date.base;

import java.io.IOException;
import java.util.Date;
import net.sf.mmm.util.date.api.IllegalDateFormatException;
import net.sf.mmm.util.date.api.Iso8601UtilLimited;
import net.sf.mmm.util.exception.api.NlsParseException;
import net.sf.mmm.util.filter.api.CharFilter;
import net.sf.mmm.util.scanner.base.CharSequenceScanner;

public class Iso8601UtilLimitedImpl
implements Iso8601UtilLimited {
    protected static final int MAX_DAY_OF_MONTH = 31;
    protected static final int MAX_MONTH = 12;
    private static Iso8601UtilLimitedImpl instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Iso8601UtilLimited getInstance() {
        if (instance != null) return instance;
        Class<Iso8601UtilLimitedImpl> clazz = Iso8601UtilLimitedImpl.class;
        synchronized (Iso8601UtilLimitedImpl.class) {
            if (instance != null) return instance;
            instance = new Iso8601UtilLimitedImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public String formatDate(Date date) {
        return this.formatDate(date, true);
    }

    @Override
    public String formatDate(Date date, boolean extended) {
        StringBuilder buffer = new StringBuilder(10);
        this.formatDate(date, extended, buffer);
        return buffer.toString();
    }

    @Override
    public void formatDate(Date date, boolean extended, Appendable buffer) {
        int year = date.getYear();
        int month = date.getMonth() - 1;
        int day = date.getDay();
        this.formatDate(year, month, day, extended, buffer);
    }

    public void formatDate(int year, int month, int day, boolean extended, Appendable buffer) {
        try {
            String dayString;
            String monthString;
            String yearString = String.valueOf(year);
            buffer.append(yearString);
            if (extended) {
                buffer.append('-');
            }
            if ((monthString = String.valueOf(month)).length() < 2) {
                buffer.append('0');
            }
            buffer.append(monthString);
            if (extended) {
                buffer.append('-');
            }
            if ((dayString = String.valueOf(day)).length() < 2) {
                buffer.append('0');
            }
            buffer.append(dayString);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String formatDateTime(Date date) {
        return this.formatDateTime(date, true, true, true);
    }

    @Override
    public String formatDateTime(Date date, boolean extendedDate, boolean extendedTime, boolean extendedTimezone) {
        StringBuilder buffer = new StringBuilder(20);
        this.formatDateTime(date, extendedDate, extendedTime, extendedTimezone, buffer);
        return buffer.toString();
    }

    @Override
    public void formatDateTime(Date date, boolean extendedDate, boolean extendedTime, boolean extendedTimeZone, Appendable buffer) {
        try {
            this.formatDate(date, extendedDate, buffer);
            buffer.append('T');
            this.formatTime(date, extendedTime, buffer);
            buffer.append('Z');
            this.formatTimeZone(date.getTimezoneOffset(), extendedTimeZone, buffer);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void formatTime(Date date, boolean extended, Appendable buffer) {
        int hours = date.getHours();
        int minutes = date.getMinutes();
        int seconds = date.getSeconds();
        this.formatTime(hours, minutes, seconds, extended, buffer);
    }

    public void formatTime(int hours, int minutes, int seconds, boolean extended, Appendable buffer) {
        try {
            String second;
            String minute;
            String hour = String.valueOf(hours);
            if (hour.length() < 2) {
                buffer.append('0');
            }
            buffer.append(hour);
            if (extended) {
                buffer.append(':');
            }
            if ((minute = String.valueOf(minutes)).length() < 2) {
                buffer.append('0');
            }
            buffer.append(minute);
            if (extended) {
                buffer.append(':');
            }
            if ((second = String.valueOf(seconds)).length() < 2) {
                buffer.append('0');
            }
            buffer.append(second);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void formatTimeZone(int timezoneOffset, boolean extended, Appendable buffer) {
        try {
            String minutes;
            int offsetSeconds = timezoneOffset / 1000;
            if (offsetSeconds < 0) {
                buffer.append('-');
                offsetSeconds = -offsetSeconds;
            } else {
                buffer.append('+');
            }
            int offsetMinutes = offsetSeconds / 60;
            String hours = String.valueOf(offsetMinutes / 60);
            if (hours.length() < 2) {
                buffer.append('0');
            }
            buffer.append(hours);
            if (extended) {
                buffer.append(':');
            }
            if ((minutes = String.valueOf(offsetMinutes % 60)).length() < 2) {
                buffer.append('0');
            }
            buffer.append(minutes);
            int seconds = offsetSeconds % 60;
            if (seconds != 0 && extended) {
                buffer.append(':');
                String secs = String.valueOf(seconds);
                if (secs.length() < 2) {
                    buffer.append('0');
                }
                buffer.append(secs);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Date parseDate(String dateIso8601) {
        Date date;
        CharSequenceScanner scanner = new CharSequenceScanner(dateIso8601);
        int[] ymd = this.parseDate(scanner);
        int year = ymd[0] - 1900;
        int month = ymd[1] - 1;
        int day = ymd[2];
        char c = scanner.forceNext();
        if (c == 'T') {
            int[] hms = this.parseTime(scanner);
            Integer timeZoneOffset = this.parseTimezoneOffset(scanner);
            int hour = hms[0];
            int min = hms[1];
            int sec = hms[2];
            date = new Date(year, month, day, hour, min, sec);
            if (timeZoneOffset != null) {
                date = new Date(date.getTime() + (long)timeZoneOffset.intValue());
            }
        } else if (c == '\u0000') {
            date = new Date(ymd[0] + 1900, ymd[1] - 1, ymd[2]);
        } else {
            throw new NlsParseException((CharSequence)scanner.getOriginalString(), (CharSequence)"([0-2][0-9])[:]?([0-5][0-9])[:]?([0-5][0-9])", (Object)"time", (Object)scanner.toString());
        }
        return date;
    }

    protected Integer parseTimezoneOffset(CharSequenceScanner scanner) {
        char c = scanner.forceNext();
        if (c == '+' || c == '-') {
            boolean negate = c == '-';
            int[] hourMinuteSecond = this.parseTime(scanner);
            int hour = hourMinuteSecond[0];
            int minute = hourMinuteSecond[1];
            int second = hourMinuteSecond[2];
            int timezoneOffset = ((hour * 60 + minute) * 60 + second) * 1000;
            if (negate) {
                timezoneOffset = -timezoneOffset;
            }
            return timezoneOffset;
        }
        if (c == '\u0000') {
            return null;
        }
        if (c == 'Z') {
            return null;
        }
        throw new IllegalArgumentException("Illegal date-format \"" + scanner.toString() + "\"!");
    }

    protected int[] parseDate(CharSequenceScanner scanner) {
        int year = 0;
        int month = -1;
        int day = -1;
        try {
            String yearString = scanner.readWhile(CharFilter.LATIN_DIGIT_FILTER);
            if (yearString.length() == 8) {
                year = Integer.parseInt(yearString.substring(0, 4));
                month = Integer.parseInt(yearString.substring(4, 6));
                day = Integer.parseInt(yearString.substring(6, 8));
            } else {
                char c = scanner.forceNext();
                if (c == '-') {
                    year = Integer.parseInt(yearString);
                    String monthString = scanner.readWhile(CharFilter.LATIN_DIGIT_FILTER);
                    if (monthString.length() == 2) {
                        String dayString;
                        month = Integer.parseInt(monthString);
                        c = scanner.forceNext();
                        if (c == '-' && (dayString = scanner.readWhile(CharFilter.LATIN_DIGIT_FILTER)).length() == 2) {
                            day = Integer.parseInt(dayString);
                        }
                    }
                }
            }
            if (month < 1 || month > 12 || day < 1 || day > 31) {
                throw new IllegalDateFormatException(scanner.getOriginalString());
            }
            return new int[]{year, month, day};
        }
        catch (Exception e) {
            throw new IllegalDateFormatException(scanner.getOriginalString(), e);
        }
    }

    private int read2Digits(CharSequenceScanner scanner) throws IllegalDateFormatException {
        int highDigit = scanner.readDigit();
        if (highDigit == -1) {
            return -1;
        }
        int lowDigit = scanner.readDigit();
        if (lowDigit == -1) {
            throw new IllegalDateFormatException(scanner.getOriginalString());
        }
        return highDigit * 10 + lowDigit;
    }

    protected int[] parseTime(CharSequenceScanner scanner) {
        int hour = this.read2Digits(scanner);
        boolean colon = scanner.expect(':');
        int minute = this.read2Digits(scanner);
        int second = 0;
        if (minute == -1) {
            if (!colon) {
                minute = 0;
            }
        } else {
            colon = scanner.expect(':');
            second = this.read2Digits(scanner);
            if (second == -1 && !colon) {
                second = 0;
            }
            if (hour < 0 || hour > 23 || minute < 0 || minute > 59 || second < 0 || second > 59) {
                throw new IllegalDateFormatException(scanner.getOriginalString());
            }
        }
        return new int[]{hour, minute, second};
    }
}

