/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.component.impl;

import net.sf.mmm.util.component.api.IocContainer;
import net.sf.mmm.util.component.api.ResourceAmbiguousException;
import net.sf.mmm.util.component.api.ResourceMissingException;
import net.sf.mmm.util.component.base.AbstractLoggableComponent;
import net.sf.mmm.util.exception.api.ObjectDisposedException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public abstract class AbstractSpringContainer
extends AbstractLoggableComponent
implements IocContainer {
    private ApplicationContext applicationContext;

    protected AbstractSpringContainer(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.initialize();
    }

    protected AbstractSpringContainer() {
    }

    protected ApplicationContext getContext() {
        this.getInitializationState().requireInitilized();
        if (this.applicationContext == null) {
            throw new ObjectDisposedException(this);
        }
        return this.applicationContext;
    }

    void setContext(ApplicationContext context) {
        this.getInitializationState().requireNotInitilized();
        this.applicationContext = context;
    }

    @Override
    public <COMPONENT_API> COMPONENT_API get(Class<COMPONENT_API> apiClass) {
        Object component = null;
        String[] componentIds = this.getContext().getBeanNamesForType(apiClass);
        if (componentIds != null && componentIds.length > 0) {
            if (componentIds.length > 1) {
                throw new ResourceAmbiguousException(apiClass.getName(), componentIds);
            }
            String componentId = componentIds[0];
            component = this.getContext().getBean(componentId);
        }
        if (component == null) {
            throw new ResourceMissingException(apiClass.getName());
        }
        return (COMPONENT_API)component;
    }

    @Override
    public <COMPONENT_API> COMPONENT_API get(Class<COMPONENT_API> apiClass, String componentId) {
        Object component;
        try {
            component = this.getContext().getBean(componentId, apiClass);
            if (component == null) {
                throw new ResourceMissingException(componentId + " [" + apiClass.getName() + "]");
            }
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new ResourceMissingException(componentId + " [" + apiClass.getName() + "]", e);
        }
        return (COMPONENT_API)component;
    }

    @Override
    public void dispose() {
        if (this.applicationContext != null) {
            if (this.applicationContext instanceof ConfigurableApplicationContext) {
                ConfigurableApplicationContext context = (ConfigurableApplicationContext)this.applicationContext;
                context.stop();
                context.close();
            }
            this.applicationContext = null;
        }
    }

    @Override
    public boolean isDisposed() {
        return this.applicationContext == null;
    }
}

