/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.collection.base;

import java.util.Map;
import net.sf.mmm.util.collection.api.MapFactory;
import net.sf.mmm.util.collection.base.HashMapFactory;

public abstract class AbstractClassHierarchyMap<E> {
    private final Map<Class<?>, E> classMap;

    public AbstractClassHierarchyMap() {
        this(HashMapFactory.INSTANCE);
    }

    public AbstractClassHierarchyMap(MapFactory<Map> mapFactory) {
        this.classMap = mapFactory.create();
    }

    public E get(Class<?> type) {
        return this.classMap.get(type);
    }

    protected boolean isPreferable(E element, Class<?> elementType, E existing, Class<?> currentType) {
        return false;
    }

    protected E put(Class<?> type, E element) {
        E old = this.classMap.get(type);
        this.putRecursive(type, element, type);
        return old;
    }

    private void putRecursive(Class<?> type, E element, Class<?> elementType) {
        for (Class<?> clazz = type; clazz != null; clazz = clazz.getSuperclass()) {
            if (this.isAccepted(clazz)) {
                boolean add;
                E existing = this.classMap.get(clazz);
                boolean bl = add = existing == null;
                if (existing != null) {
                    if (existing == element) {
                        return;
                    }
                    add = this.isPreferable(element, elementType, existing, clazz);
                }
                if (add) {
                    this.classMap.put(clazz, element);
                }
            }
            for (Class<?> interfaceClass : clazz.getInterfaces()) {
                if (!this.isAccepted(interfaceClass)) continue;
                this.putRecursive(interfaceClass, element, elementType);
            }
        }
    }

    protected boolean isAccepted(Class<?> type) {
        return true;
    }
}

