/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.cobigen.api.externalprocess;

import com.devonfw.cobigen.api.exception.CobiGenRuntimeException;
import com.devonfw.cobigen.api.exception.MergeException;
import com.devonfw.cobigen.api.extension.Merger;
import com.devonfw.cobigen.api.externalprocess.ExternalProcess;
import com.devonfw.cobigen.api.externalprocess.to.MergeTo;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;

public class ExternalServerMergerProxy
implements Merger {
    protected ExternalProcess externalProcess;
    protected boolean patchOverrides;

    public ExternalServerMergerProxy(ExternalProcess externalProcess, boolean patchOverrides) {
        this.externalProcess = externalProcess;
        this.patchOverrides = patchOverrides;
    }

    public String getType() {
        throw new CobiGenRuntimeException("This method should be implemented in Java for performance reasons!");
    }

    public String merge(File base, String patch, String targetCharset) throws MergeException {
        String baseFileContents;
        try {
            baseFileContents = new String(Files.readAllBytes(base.toPath()), Charset.forName(targetCharset));
        }
        catch (IOException e) {
            throw new MergeException(base, "Could not read base file!", (Throwable)e);
        }
        MergeTo mergeTo = new MergeTo(baseFileContents, patch, this.patchOverrides);
        return this.externalProcess.postJsonRequest("merge", mergeTo);
    }
}

