/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.metadata;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import ma.glasnost.orika.MappedTypePair;
import ma.glasnost.orika.Mapper;
import ma.glasnost.orika.metadata.FieldMap;
import ma.glasnost.orika.metadata.MapperKey;
import ma.glasnost.orika.metadata.Type;

public class ClassMap<A, B>
implements MappedTypePair<A, B> {
    private final Type<A> aType;
    private final Type<B> bType;
    private final Set<FieldMap> fieldsMapping;
    private final Set<MapperKey> usedMappers;
    private final Mapper<A, B> customizedMapper;
    private final String[] constructorA;
    private final String[] constructorB;
    private final MapperKey mapperKey;
    private final Boolean sourcesMappedOnNull;
    private final Boolean destinationsMappedOnNull;
    private final Boolean favorsExtension;

    public ClassMap(Type<A> aType, Type<B> bType, Set<FieldMap> fieldsMapping, Mapper<A, B> customizedMapper, Set<MapperKey> usedMappers, String[] constructorA, String[] constructorB, Boolean sourcesMappedOnNull, Boolean destinationsMappedOnNull, Boolean favorsExtension) {
        this.aType = aType;
        this.bType = bType;
        this.customizedMapper = customizedMapper;
        this.fieldsMapping = Collections.unmodifiableSet(fieldsMapping);
        this.usedMappers = Collections.unmodifiableSet(usedMappers);
        this.mapperKey = new MapperKey(aType, bType);
        this.sourcesMappedOnNull = sourcesMappedOnNull;
        this.destinationsMappedOnNull = destinationsMappedOnNull;
        this.favorsExtension = favorsExtension;
        this.constructorA = constructorA != null ? (String[])constructorA.clone() : null;
        this.constructorB = constructorB != null ? (String[])constructorB.clone() : null;
    }

    public ClassMap<A, B> copy(Set<FieldMap> fieldsMapping) {
        LinkedHashSet<MapperKey> usedMappers = new LinkedHashSet<MapperKey>();
        usedMappers.addAll(this.usedMappers);
        String[] constructorA = this.constructorA == null ? null : (String[])this.constructorA.clone();
        String[] constructorB = this.constructorB == null ? null : (String[])this.constructorB.clone();
        return new ClassMap<A, B>(this.aType, this.bType, fieldsMapping, this.customizedMapper, usedMappers, constructorA, constructorB, this.sourcesMappedOnNull, this.destinationsMappedOnNull, this.favorsExtension);
    }

    public ClassMap<A, B> copyWithUsedMappers(Set<MapperKey> usedMappers) {
        return new ClassMap<A, B>(this.aType, this.bType, this.fieldsMapping, this.customizedMapper, usedMappers, this.constructorA, this.constructorB, this.sourcesMappedOnNull, this.destinationsMappedOnNull, this.favorsExtension);
    }

    public MapperKey getMapperKey() {
        return this.mapperKey;
    }

    public void addFieldMap(FieldMap fieldMap) {
        this.fieldsMapping.add(fieldMap);
    }

    @Override
    public Type<A> getAType() {
        return this.aType;
    }

    @Override
    public Type<B> getBType() {
        return this.bType;
    }

    public Set<FieldMap> getFieldsMapping() {
        return this.fieldsMapping;
    }

    public String getATypeName() {
        return this.aType.getSimpleName();
    }

    public String getBTypeName() {
        return this.bType.getSimpleName();
    }

    public Mapper<A, B> getCustomizedMapper() {
        return this.customizedMapper;
    }

    public String getMapperClassName() {
        String className = "Orika_" + this.getBTypeName() + "_" + this.getATypeName() + "_Mapper";
        boolean aIsPublic = Modifier.isPublic(((Class)this.getAType().getRawType()).getModifiers());
        boolean bIsPublic = Modifier.isPublic(((Class)this.getBType().getRawType()).getModifiers());
        if (aIsPublic) {
            if (bIsPublic) {
                return className;
            }
            return ClassMap.prependPackageName(ClassMap.getPackageName(this.getBType()), className);
        }
        if (bIsPublic) {
            return ClassMap.prependPackageName(ClassMap.getPackageName(this.getAType()), className);
        }
        String aPackage = ClassMap.getPackageName(this.getAType());
        if (aPackage.equals(ClassMap.getPackageName(this.getBType()))) {
            return ClassMap.prependPackageName(aPackage, className);
        }
        throw new RuntimeException(this.getAType() + " and " + this.getBType() + " are both package private but are in different packages");
    }

    private static String prependPackageName(String packageName, String className) {
        return packageName.isEmpty() || packageName.startsWith("java.") ? className : packageName + "." + className;
    }

    private static String getPackageName(Type<?> type) {
        Package typePackage = ((Class)type.getRawType()).getPackage();
        return type == null ? "" : typePackage.getName();
    }

    public String[] getConstructorA() {
        return this.constructorA;
    }

    public String[] getConstructorB() {
        return this.constructorB;
    }

    public Boolean areSourcesMappedOnNull() {
        return this.sourcesMappedOnNull;
    }

    public Boolean areDestinationsMappedOnNull() {
        return this.destinationsMappedOnNull;
    }

    public Boolean favorsExtension() {
        return this.favorsExtension;
    }

    public int hashCode() {
        int result = 31;
        result += this.aType == null ? 0 : this.aType.hashCode();
        return result += this.bType == null ? 0 : this.bType.hashCode();
    }

    public Set<MapperKey> getUsedMappers() {
        return this.usedMappers;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "([A]:" + this.aType + ", [B]:" + this.bType + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassMap other = (ClassMap)obj;
        if (this.aType == null ? other.aType != null : !this.aType.equals(other.aType)) {
            return false;
        }
        return !(this.bType == null ? other.bType != null : !this.bType.equals(other.bType));
    }
}

