/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator.specification;

import ma.glasnost.orika.MappingException;
import ma.glasnost.orika.impl.generator.SourceCodeContext;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.impl.generator.specification.AbstractSpecification;
import ma.glasnost.orika.metadata.FieldMap;
import ma.glasnost.orika.metadata.TypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimitiveAndObject
extends AbstractSpecification {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrimitiveAndObject.class);

    @Override
    public boolean appliesTo(FieldMap fieldMap) {
        return fieldMap.getSource().getType().isPrimitive() && !TypeFactory.TYPE_OF_OBJECT.equals(fieldMap.getDestination().getType()) || fieldMap.getDestination().getType().isPrimitive();
    }

    @Override
    public String generateEqualityTestCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        return source + " == " + destination;
    }

    @Override
    public String generateMappingCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        LOGGER.debug("PrimitiveAndObject condition occurred; context: \nsrc: " + source.property() + "\nsrc.isArrayElement: " + source.property().isArrayElement() + "\nsrc.isListElement: " + source.property().isListElement() + "\nsrc.isMapKey: " + source.property().isMapKey() + "\ndest: " + destination.property() + "\ndest.isArrayElement: " + destination.property().isArrayElement() + "\ndest.isListElement: " + destination.property().isListElement() + "\ndest.isMapKey: " + destination.property().isMapKey());
        throw new MappingException("Encountered mapping of primitive to object (or vise-versa); sourceType=" + source.type() + ", destinationType=" + destination.type());
    }
}

