/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator;

import java.io.Reader;
import java.io.StringReader;
import ma.glasnost.orika.MappingException;
import ma.glasnost.orika.impl.generator.ByteArrayClassLoader;
import ma.glasnost.orika.impl.generator.CompilerStrategy;
import ma.glasnost.orika.impl.generator.SourceCodeContext;
import org.codehaus.janino.ClassLoaderIClassLoader;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.UnitCompiler;
import org.codehaus.janino.util.ClassFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaninoCompilerStrategy
extends CompilerStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(JaninoCompilerStrategy.class);
    private static final String WRITE_SOURCE_FILES_BY_DEFAULT = "false";
    private static final String WRITE_CLASS_FILES_BY_DEFAULT = "false";
    private ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
    private ByteArrayClassLoader classLoader;
    private IClassLoader iClassLoader = new ClassLoaderIClassLoader(this.parentClassLoader);

    public JaninoCompilerStrategy() {
        super("false", "false");
        this.classLoader = new ByteArrayClassLoader(this.parentClassLoader);
    }

    @Override
    public Class<?> compileClass(SourceCodeContext sourceCode) throws CompilerStrategy.SourceCodeGenerationException {
        try {
            Scanner scanner = new Scanner(sourceCode.getClassName(), (Reader)new StringReader(sourceCode.toSourceFile()));
            Java.CompilationUnit localCompilationUnit = new Parser(scanner).parseCompilationUnit();
            UnitCompiler unitCompile = new UnitCompiler(localCompilationUnit, this.iClassLoader);
            ClassFile[] classes = unitCompile.compileUnit(false, false, false);
            return this.classLoader.findClass(classes[0].getThisClassName());
        }
        catch (Exception e) {
            LOG.error("Can not compile {0}", (Object)sourceCode.getClassName(), (Object)e);
            throw new MappingException("Can not compile the generated mapper", e);
        }
    }

    @Override
    public void assureTypeIsAccessible(Class<?> type) throws CompilerStrategy.SourceCodeGenerationException {
    }
}

