/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.converter.builtin;

import com.google.common.base.Optional;
import ma.glasnost.orika.Converter;
import ma.glasnost.orika.MapperFacade;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;

public class GuavaOptionalConverter<S, D>
implements Converter<Optional<S>, Optional<D>> {
    private final Type<S> sourceType;
    private final Type<D> destinationType;
    private MapperFacade mapper;

    public GuavaOptionalConverter(Type<S> sourceType, Type<D> destinationType) {
        this.sourceType = sourceType;
        this.destinationType = destinationType;
    }

    @Override
    public boolean canConvert(Type<?> sourceType, Type<?> destinationType) {
        Type<?> sourceComponentType = sourceType.getComponentType();
        Type<?> destinationComponentType = destinationType.getComponentType();
        return sourceComponentType != null && destinationComponentType != null && this.sourceType.isAssignableFrom((Class<?>)sourceComponentType.getRawType()) && this.destinationType.isAssignableFrom((Class<?>)destinationComponentType.getRawType());
    }

    @Override
    public Optional<D> convert(Optional<S> optionalSource, Type<? extends Optional<D>> destinationType, MappingContext mappingContext) {
        if (!optionalSource.isPresent()) {
            return Optional.absent();
        }
        Object source = optionalSource.get();
        return Optional.fromNullable(this.mapper.map(source, this.sourceType, this.destinationType, mappingContext));
    }

    @Override
    public void setMapperFacade(MapperFacade mapper) {
        this.mapper = mapper;
    }

    @Override
    public Type<Optional<S>> getAType() {
        return this.getOptionalTypeOf(this.sourceType);
    }

    @Override
    public Type<Optional<D>> getBType() {
        return this.getOptionalTypeOf(this.destinationType);
    }

    private <T> Type<Optional<T>> getOptionalTypeOf(Type<T> type) {
        return TypeFactory.valueOf(Optional.class, type);
    }
}

