/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.cobigen.api.to;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HealthCheckReport {
    private List<String> expectedTemplatesConfigurations = Lists.newArrayList();
    private Set<String> hasConfiguration = Sets.newHashSet();
    private Set<String> isAccessible = Sets.newHashSet();
    private Map<String, Path> upgradeableConfigurations = Maps.newHashMap();
    private Set<String> upToDateConfigurations = Sets.newHashSet();
    private String healthyCheckMessage = "";
    private List<RuntimeException> errors = Lists.newArrayList();
    private List<String> errorMessages = Lists.newArrayList();

    public List<RuntimeException> getErrors() {
        return this.errors;
    }

    public Exception getFirstError(Class<?> c) {
        Iterator<RuntimeException> it = this.errors.iterator();
        while (it.hasNext()) {
            if (!it.next().getClass().equals(c)) continue;
            return it.next();
        }
        return null;
    }

    public boolean containsError(Class<?> errorClass) {
        Iterator<RuntimeException> it = this.errors.iterator();
        while (it.hasNext()) {
            if (!it.next().getClass().equals(errorClass)) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfErrors() {
        return this.getErrors().size();
    }

    public void setErrors(List<RuntimeException> errors) {
        this.errors = errors;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public void addErrorMessages(String errorMessage) {
        if (this.errorMessages == null) {
            this.errorMessages = new ArrayList<String>();
        }
        this.errorMessages.add(errorMessage);
    }

    public void addError(RuntimeException e) {
        this.errors.add(e);
    }

    public String getHealthyCheckMessage() {
        return this.healthyCheckMessage;
    }

    public void setHealthyCheckMessage(String healthyCheckMessage) {
        this.healthyCheckMessage = healthyCheckMessage;
    }

    public void appendToHealthyCheckMessage(String input) {
        this.healthyCheckMessage = this.healthyCheckMessage + input;
    }

    public List<String> getExpectedTemplatesConfigurations() {
        return this.expectedTemplatesConfigurations;
    }

    public void setExpectedTemplatesConfigurations(List<String> expectedTemplatesConfigurations) {
        this.expectedTemplatesConfigurations = expectedTemplatesConfigurations;
    }

    public Set<String> getHasConfiguration() {
        return this.hasConfiguration;
    }

    public void setHasConfiguration(Set<String> hasConfiguration) {
        this.hasConfiguration = hasConfiguration;
    }

    public Set<String> getIsAccessible() {
        return this.isAccessible;
    }

    public void setIsAccessible(Set<String> isAccessible) {
        this.isAccessible = isAccessible;
    }

    public Map<String, Path> getUpgradeableConfigurations() {
        return this.upgradeableConfigurations;
    }

    public void setUpgradeableConfigurations(Map<String, Path> upgradeableConfigurations) {
        this.upgradeableConfigurations = upgradeableConfigurations;
    }

    public Set<String> getUpToDateConfigurations() {
        return this.upToDateConfigurations;
    }

    public void setUpToDateConfigurations(Set<String> upToDateConfigurations) {
        this.upToDateConfigurations = upToDateConfigurations;
    }
}

