/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.cobigen.cli.utils;

import com.devonfw.cobigen.cli.utils.CobiGenUtils;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import picocli.CommandLine;

public class CobiGenVersionProvider
implements CommandLine.IVersionProvider {
    public String[] getVersion() throws Exception {
        Model model = null;
        ArrayList<Object> versionProvider = new ArrayList<Object>();
        MavenXpp3Reader reader = new MavenXpp3Reader();
        File pomFile = CobiGenUtils.extractArtificialPom();
        if (pomFile.exists()) {
            try (FileReader pomReader = new FileReader(pomFile);){
                model = reader.read((Reader)pomReader);
                versionProvider.add("CobiGen CLI " + model.getVersion());
                versionProvider.add("");
            }
        } else {
            versionProvider.add("Error while retrieving CLI version. Pom.xml was not found on your PC. This is a bug");
            return versionProvider.toArray(new String[versionProvider.size()]);
        }
        List modelDependencies = model.getDependencies();
        for (int i = 0; i < modelDependencies.size(); ++i) {
            String artifactId = ((Dependency)modelDependencies.get(i)).getArtifactId();
            String version = ((Dependency)modelDependencies.get(i)).getVersion();
            if (!this.dependencyShouldBePrinted(((Dependency)modelDependencies.get(i)).getGroupId()).booleanValue()) continue;
            versionProvider.add("Plugin: " + artifactId + " " + version);
        }
        return versionProvider.toArray(new String[versionProvider.size()]);
    }

    private Boolean dependencyShouldBePrinted(String groupId) {
        if ("com.devonfw.cobigen".equals(groupId)) {
            return true;
        }
        return false;
    }
}

