/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.xml.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.mmm.util.component.base.AbstractLoggableComponent;
import net.sf.mmm.util.exception.api.NlsIllegalStateException;
import net.sf.mmm.util.exception.api.NlsParseException;
import net.sf.mmm.util.io.api.IoMode;
import net.sf.mmm.util.io.api.RuntimeIoException;
import net.sf.mmm.util.lang.api.BasicUtil;
import net.sf.mmm.util.lang.api.CharIterator;
import net.sf.mmm.util.lang.api.StringUtil;
import net.sf.mmm.util.lang.base.BasicUtilImpl;
import net.sf.mmm.util.lang.base.SpaceNormalizingCharIterator;
import net.sf.mmm.util.xml.api.DomUtil;
import net.sf.mmm.util.xml.api.XmlCompareMode;
import net.sf.mmm.util.xml.api.XmlException;
import net.sf.mmm.util.xml.base.JoiningNodeIterator;
import net.sf.mmm.util.xml.base.NodeValueCharIterator;
import net.sf.mmm.util.xml.base.XmlInvalidException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DomUtilImpl
extends AbstractLoggableComponent
implements DomUtil {
    private static DomUtil instance;
    private DocumentBuilderFactory documentBuilderFactory;
    private TransformerFactory transformerFactory;
    private BasicUtil basicUtil;

    protected DocumentBuilderFactory getDocumentBuilderFactory() {
        return this.documentBuilderFactory;
    }

    public void setDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        this.getInitializationState().requireNotInitilized();
        this.documentBuilderFactory = documentBuilderFactory;
    }

    protected TransformerFactory getTransformerFactory() {
        return this.transformerFactory;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.getInitializationState().requireNotInitilized();
        this.transformerFactory = transformerFactory;
    }

    protected BasicUtil getBasicUtil() {
        return this.basicUtil;
    }

    @Inject
    public void setBasicUtil(BasicUtil basicUtil) {
        this.getInitializationState().requireNotInitilized();
        this.basicUtil = basicUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DomUtil getInstance() {
        if (instance != null) return instance;
        Class<DomUtilImpl> clazz = DomUtilImpl.class;
        synchronized (DomUtilImpl.class) {
            if (instance != null) return instance;
            DomUtilImpl util = new DomUtilImpl();
            util.initialize();
            instance = util;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    protected void doInitialize() {
        Object factory;
        super.doInitialize();
        if (this.documentBuilderFactory == null) {
            try {
                factory = DocumentBuilderFactory.newInstance();
                ((DocumentBuilderFactory)factory).setNamespaceAware(true);
                this.documentBuilderFactory = factory;
            }
            catch (FactoryConfigurationError e) {
                throw new NlsIllegalStateException(e);
            }
        }
        if (this.transformerFactory == null) {
            try {
                this.transformerFactory = factory = TransformerFactory.newInstance();
            }
            catch (TransformerFactoryConfigurationError e) {
                throw new NlsIllegalStateException(e);
            }
        }
        if (this.basicUtil == null) {
            this.basicUtil = BasicUtilImpl.getInstance();
        }
    }

    private DocumentBuilder createDocumentBuilder() {
        try {
            return this.documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("XML Parser misconfigured! Probably your JVM does not support the required JAXP version!", e);
        }
    }

    private Transformer createTransformer(boolean indent) {
        try {
            Transformer result = this.transformerFactory.newTransformer();
            if (indent) {
                result.setOutputProperty("indent", "yes");
            }
            return result;
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException("XML Transformer misconfigured! Probably your JVM does not support the required JAXP version!", e);
        }
    }

    @Override
    public Element getFirstElement(NodeList nodeList) {
        return this.getFirstElement(nodeList, null);
    }

    @Override
    public Element getFirstElement(NodeList nodeList, String tagName) {
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            if (tagName != null && !tagName.equals(element.getTagName())) continue;
            return element;
        }
        return null;
    }

    @Override
    public Element getFirstChildElement(Element element, String tagName) {
        return this.getFirstElement(element.getChildNodes(), tagName);
    }

    @Override
    public Element requireFirstChildElement(Element element, String tagName) throws IllegalArgumentException {
        Element result = this.getFirstChildElement(element, tagName);
        if (result == null) {
            throw new IllegalArgumentException("Missing element '" + tagName + "' in element '" + element.getTagName() + "'!");
        }
        return result;
    }

    @Override
    public boolean getAttributeAsBoolean(Element element, String attribute, boolean defaultValue) throws IllegalArgumentException {
        boolean result = defaultValue;
        if (element.hasAttribute(attribute)) {
            String flag = element.getAttribute(attribute);
            if (StringUtil.TRUE.equalsIgnoreCase(flag)) {
                result = true;
            } else if (StringUtil.FALSE.equalsIgnoreCase(flag)) {
                result = false;
            } else {
                throw new NlsParseException(flag, (CharSequence)(element.getTagName() + "@" + attribute), Boolean.TYPE);
            }
        }
        return result;
    }

    @Override
    public String getNodeText(Node node) {
        return this.getNodeText(node, 0);
    }

    @Override
    public String getNodeText(Node node, int depth) {
        StringBuffer buffer = new StringBuffer();
        this.getNodeText(node, buffer, depth);
        return buffer.toString();
    }

    @Override
    public void getNodeText(Node node, Appendable buffer, int depth) {
        try {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node childNode = nodeList.item(i);
                if (childNode.getNodeType() == 3 || childNode.getNodeType() == 4) {
                    buffer.append(childNode.getNodeValue());
                    continue;
                }
                if (depth <= 0 || childNode.getNodeType() != 1) continue;
                this.getNodeText(childNode, buffer, depth - 1);
            }
        }
        catch (IOException e) {
            throw new RuntimeIoException((Throwable)e, IoMode.WRITE);
        }
    }

    @Override
    public void removeChildren(Element node) {
        NodeList children = node.getChildNodes();
        for (int i = children.getLength() - 1; i >= 0; --i) {
            node.removeChild(children.item(i));
        }
    }

    @Override
    public Document createDocument() {
        return this.createDocumentBuilder().newDocument();
    }

    @Override
    public Document parseDocument(InputStream inputStream) throws XmlException, IOException {
        try {
            Document document = this.createDocumentBuilder().parse(inputStream);
            return document;
        }
        catch (SAXException e) {
            throw new XmlInvalidException(e);
        }
        finally {
            inputStream.close();
        }
    }

    @Override
    public Document parseDocument(Reader reader) throws XmlException {
        return this.parseDocument(new InputSource(reader));
    }

    @Override
    public Document parseDocument(InputSource inputSource) throws XmlException {
        try {
            return this.createDocumentBuilder().parse(inputSource);
        }
        catch (SAXException e) {
            throw new XmlInvalidException(e);
        }
        catch (IOException e) {
            throw new RuntimeIoException((Throwable)e, IoMode.READ);
        }
    }

    @Override
    public void writeXml(Node xmlNode, OutputStream outputStream, boolean indent) throws XmlException {
        this.transformXml(new DOMSource(xmlNode), new StreamResult(outputStream), indent);
    }

    @Override
    public void writeXml(Node xmlNode, Writer writer, boolean indent) throws XmlException {
        this.transformXml(new DOMSource(xmlNode), new StreamResult(writer), indent);
    }

    @Override
    public void transformXml(Source source, Result result, boolean indent) throws XmlException {
        try {
            this.createTransformer(indent).transform(source, result);
        }
        catch (TransformerException e) {
            throw new XmlInvalidException(e);
        }
    }

    @Override
    public String getLocalName(Node node) {
        String localName = node.getLocalName();
        if (localName == null) {
            localName = node.getNodeName();
        }
        return localName;
    }

    private boolean isEqualName(Node node1, Node node2) {
        if (!this.basicUtil.isEqual(node1.getNamespaceURI(), node2.getNamespaceURI())) {
            return false;
        }
        return this.basicUtil.isEqual(this.getLocalName(node1), this.getLocalName(node2));
    }

    @Override
    public boolean isEqual(Node node1, Node node2, XmlCompareMode mode) {
        short type2;
        if (node1 == null) {
            return node2 == null;
        }
        if (node2 == null) {
            return false;
        }
        short type1 = node1.getNodeType();
        if (type1 != (type2 = node2.getNodeType())) {
            boolean accept = false;
            if (mode.isJoinText() && mode.isJoinCData() && (type1 == 3 && type2 == 4 || type1 == 4 && type2 == 3)) {
                accept = true;
            }
            if (!accept) {
                return false;
            }
        }
        if (type1 == 1) {
            return this.isEqual((Element)node1, (Element)node2, mode);
        }
        if (type1 == 2) {
            if (!this.isEqualName(node1, node2)) {
                return false;
            }
            return this.basicUtil.isEqual(node1.getNodeValue(), node2.getNodeValue());
        }
        if (type1 == 8 && !mode.isCheckComments()) {
            return true;
        }
        if (type1 == 3 || type1 == 4 || type1 == 8) {
            NodeValueCharIterator charIterator1 = new NodeValueCharIterator(node1);
            NodeValueCharIterator charIterator2 = new NodeValueCharIterator(node2);
            return this.isEqual(charIterator1, charIterator2, mode);
        }
        if (type1 == 9) {
            Document doc1 = (Document)node1;
            Document doc2 = (Document)node2;
            return this.isEqual(doc1.getDocumentElement(), doc2.getDocumentElement(), mode);
        }
        if (type1 == 11) {
            return this.isEqual(node1.getChildNodes(), node1.getChildNodes(), mode);
        }
        if (type1 == 6) {
            Entity entity1 = (Entity)node1;
            Entity entity2 = (Entity)node2;
            return this.basicUtil.isEqual(entity1.getNotationName(), entity2.getNotationName());
        }
        if (type1 == 7) {
            ProcessingInstruction pi1 = (ProcessingInstruction)((Object)node1);
            ProcessingInstruction pi2 = (ProcessingInstruction)((Object)node2);
            if (!this.basicUtil.isEqual(pi1.getTarget(), pi2.getTarget())) {
                return false;
            }
            return this.basicUtil.isEqual(pi1.getData(), pi2.getData());
        }
        return false;
    }

    protected boolean isEqual(CharIterator charIterator1, CharIterator charIterator2, XmlCompareMode mode) {
        CharIterator c2;
        CharIterator c1;
        if (mode.isNormalizeSpaces()) {
            c1 = new SpaceNormalizingCharIterator(charIterator1);
            c2 = new SpaceNormalizingCharIterator(charIterator2);
        } else {
            c1 = charIterator1;
            c2 = charIterator2;
        }
        return this.basicUtil.compare(c1, c2);
    }

    protected boolean isEqual(Element element1, Element element2, XmlCompareMode mode) {
        if (!this.isEqualName(element1, element2)) {
            return false;
        }
        NamedNodeMap attributes1 = element1.getAttributes();
        NamedNodeMap attributes2 = element2.getAttributes();
        int length = attributes1.getLength();
        if (attributes2.getLength() != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            Node attr1 = attributes1.item(i);
            String namespaceUri = attr1.getNamespaceURI();
            String name = this.getLocalName(attr1);
            Node attr2 = namespaceUri == null ? attributes2.getNamedItem(name) : attributes2.getNamedItemNS(namespaceUri, name);
            if (attr2 == null) {
                return false;
            }
            if (attr1.getNodeValue().equals(attr2.getNodeValue())) continue;
            return false;
        }
        return this.isEqual(element1.getChildNodes(), element2.getChildNodes(), mode);
    }

    protected boolean isEqual(NodeList nodeList1, NodeList nodeList2, XmlCompareMode mode) {
        JoiningNodeIterator nodeIterator1 = new JoiningNodeIterator(nodeList1, mode);
        JoiningNodeIterator nodeIterator2 = new JoiningNodeIterator(nodeList2, mode);
        while (nodeIterator1.hasNext()) {
            NodeValueCharIterator charIterator2;
            NodeValueCharIterator charIterator1;
            Node child1 = (Node)nodeIterator1.next();
            if (!nodeIterator2.hasNext()) {
                return false;
            }
            Node child2 = (Node)nodeIterator2.next();
            if (child1.getNodeType() == 11 && child2.getNodeType() == 11 && !this.isEqual(charIterator1 = new NodeValueCharIterator(child1.getChildNodes()), charIterator2 = new NodeValueCharIterator(child2.getChildNodes()), mode)) {
                return false;
            }
            if (this.isEqual(child1, child2, mode)) continue;
            return false;
        }
        return !nodeIterator2.hasNext();
    }
}

