/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.base.datatype.descriptor;

import net.sf.mmm.util.lang.api.DatatypeSegmentDescriptor;

public abstract class AbstractDatatypeSegmentDescriptor<T, V>
implements DatatypeSegmentDescriptor<T, V> {
    private final String name;
    private final Class<V> type;
    private final boolean optional;

    public AbstractDatatypeSegmentDescriptor(String name, Class<V> type) {
        this(name, type, false);
    }

    public AbstractDatatypeSegmentDescriptor(String name, Class<V> type, boolean optional) {
        this.name = name;
        this.type = type;
        this.optional = optional;
    }

    @Override
    public V getSegment(T datatype) {
        if (datatype == null) {
            return null;
        }
        return this.doGetSegment(datatype);
    }

    protected abstract V doGetSegment(T var1);

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<V> getType() {
        return this.type;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    public String toString() {
        return "DatatypeSegmentDescriptor for " + this.name + "@" + this.type.getName();
    }
}

