/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.base.datatype.adapter.jackson;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import javax.inject.Inject;
import net.sf.mmm.util.lang.api.DatatypeDescriptorManager;
import net.sf.mmm.util.lang.api.DatatypeDetector;
import net.sf.mmm.util.lang.api.EnumProvider;
import net.sf.mmm.util.lang.base.datatype.adapter.jackson.DatatypeJsonDeserializer;
import net.sf.mmm.util.lang.base.datatype.adapter.jackson.EnumTypeJsonDeserializer;

public class DatatypeJsonDeserializers
extends SimpleDeserializers {
    private static final long serialVersionUID = 1L;
    private DatatypeDescriptorManager datatypeDescriptorManager;
    private DatatypeDetector datatypeDetector;
    private EnumProvider enumProvider;

    @Inject
    public void setDatatypeDescriptorManager(DatatypeDescriptorManager datatypeDescriptorManager) {
        this.datatypeDescriptorManager = datatypeDescriptorManager;
    }

    @Inject
    public void setDatatypeDetector(DatatypeDetector datatypeDetector) {
        this.datatypeDetector = datatypeDetector;
    }

    @Inject
    public void setEnumProvider(EnumProvider enumProvider) {
        this.enumProvider = enumProvider;
    }

    public JsonDeserializer<?> findEnumDeserializer(Class<?> type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        return new EnumTypeJsonDeserializer(type, this.enumProvider);
    }

    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        Class datatype;
        DatatypeJsonDeserializer deserializer = super.findBeanDeserializer(type, config, beanDesc);
        if (deserializer == null && this.datatypeDetector.isDatatype(datatype = type.getRawClass()) && !this.datatypeDetector.isJavaStandardDatatype(datatype)) {
            deserializer = new DatatypeJsonDeserializer(datatype, this.datatypeDescriptorManager);
        }
        return deserializer;
    }
}

