/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import net.sf.mmm.util.lang.api.CaseConversion;
import net.sf.mmm.util.lang.base.SequenceCharIterator;

public class CaseSyntax {
    private static final List<CaseSyntax> CONSTANTS = new ArrayList<CaseSyntax>();
    private static final String REGEX_SPECIAL_CHARS = "[^\\p{IsAlphabetic}^\\p{IsDigit}]+";
    private static final Pattern PATTERN_SPECIAL_CHARS = Pattern.compile("[^\\p{IsAlphabetic}^\\p{IsDigit}]+");
    public static final Character KEEP_SPECIAL_CHARS = Character.valueOf('\u0000');
    public static final CaseSyntax LOWERCASE = new CaseSyntax(null, CaseConversion.LOWER_CASE, "lowercase");
    public static final CaseSyntax UPPERCASE = new CaseSyntax(null, CaseConversion.UPPER_CASE, "UPPERCASE");
    public static final CaseSyntax CAML_CASE = new CaseSyntax(null, CaseConversion.LOWER_CASE, CaseConversion.UPPER_CASE, CaseConversion.LOWER_CASE, "camlCase");
    public static final CaseSyntax PASCAL_CASE = new CaseSyntax(null, CaseConversion.UPPER_CASE, CaseConversion.UPPER_CASE, CaseConversion.LOWER_CASE, "PascalCase");
    public static final CaseSyntax TRAIN_CASE = new CaseSyntax(Character.valueOf('-'), CaseConversion.LOWER_CASE, "train-case");
    public static final CaseSyntax UPPER_TRAIN_CASE = new CaseSyntax(Character.valueOf('-'), CaseConversion.UPPER_CASE, "UPPER-TRAIN-CASE");
    public static final CaseSyntax PASCAL_TRAIN_CASE = new CaseSyntax(Character.valueOf('-'), CaseConversion.UPPER_CASE, CaseConversion.UPPER_CASE, CaseConversion.LOWER_CASE, "Pascal-Train-Case");
    public static final CaseSyntax CAML_TRAIN_CASE = new CaseSyntax(Character.valueOf('-'), CaseConversion.LOWER_CASE, CaseConversion.UPPER_CASE, CaseConversion.LOWER_CASE, "caml-Train-Case");
    public static final CaseSyntax LOWER_SNAKE_CASE = new CaseSyntax(Character.valueOf('_'), CaseConversion.LOWER_CASE, "lower_snake_case");
    public static final CaseSyntax UPPER_SNAKE_CASE = new CaseSyntax(Character.valueOf('_'), CaseConversion.UPPER_CASE, "UPPER_SNAKE_CASE");
    public static final CaseSyntax PASCAL_SNAKE_CASE = new CaseSyntax(Character.valueOf('_'), CaseConversion.UPPER_CASE, CaseConversion.UPPER_CASE, CaseConversion.LOWER_CASE, "Pascal_Snake_Case");
    public static final CaseSyntax CAML_SNAKE_CASE = new CaseSyntax(Character.valueOf('_'), CaseConversion.LOWER_CASE, CaseConversion.UPPER_CASE, CaseConversion.LOWER_CASE, "caml_Snake_Case");
    public static final CaseSyntax LOWER_SPACE_CASE = new CaseSyntax(Character.valueOf(' '), CaseConversion.LOWER_CASE, "lower space case");
    public static final CaseSyntax UPPER_SPACE_CASE = new CaseSyntax(Character.valueOf(' '), CaseConversion.UPPER_CASE, "UPPER SPACE CASE");
    public static final CaseSyntax PASCAL_SPACE_CASE = new CaseSyntax(Character.valueOf(' '), CaseConversion.UPPER_CASE, CaseConversion.UPPER_CASE, CaseConversion.LOWER_CASE, "Pascal Space Case");
    public static final CaseSyntax CAML_SPACE_CASE = new CaseSyntax(Character.valueOf(' '), CaseConversion.LOWER_CASE, CaseConversion.UPPER_CASE, CaseConversion.LOWER_CASE, "caml Space Case");
    public static final CaseSyntax UNMODIFIED = new CaseSyntax(null, CaseConversion.ORIGINAL_CASE, "$$$unmodified");
    public static final CaseSyntax CAPITALIZED = new CaseSyntax(null, CaseConversion.UPPER_CASE, CaseConversion.ORIGINAL_CASE, "C$$apitalized");
    public static final CaseSyntax UNCAPITALIZED = new CaseSyntax(null, CaseConversion.UPPER_CASE, CaseConversion.ORIGINAL_CASE, "u$$capitalized");
    public static final CaseSyntax CAPITALIZED_LOWER = new CaseSyntax(null, CaseConversion.UPPER_CASE, CaseConversion.LOWER_CASE, CaseConversion.LOWER_CASE, "Capitalizedlower");
    public static final CaseSyntax UNCAPITALIZED_UPPER = new CaseSyntax(null, CaseConversion.LOWER_CASE, CaseConversion.UPPER_CASE, CaseConversion.UPPER_CASE, "uNCAPITALIZEDUPPER");
    private final Character wordSeparator;
    private final CaseConversion firstCase;
    private final CaseConversion wordStartCase;
    private final CaseConversion otherCase;
    private final String example;

    private CaseSyntax(Character separator, CaseConversion allCharCase, String example) {
        this(separator, allCharCase, allCharCase, allCharCase, example, true);
    }

    private CaseSyntax(Character separator, CaseConversion firstCharCase, CaseConversion wordStartCharCase, String example) {
        this(separator, firstCharCase, wordStartCharCase, CaseConversion.ORIGINAL_CASE, example, true);
    }

    private CaseSyntax(Character separator, CaseConversion firstCharCase, CaseConversion wordStartCharCase, CaseConversion otherCharCase, String example) {
        this(separator, firstCharCase, wordStartCharCase, otherCharCase, example, true);
    }

    private CaseSyntax(Character separator, CaseConversion firstCharCase, CaseConversion wordStartCharCase, CaseConversion otherCharCase, String example, boolean register) {
        this.wordSeparator = separator;
        assert (otherCharCase != null);
        this.otherCase = otherCharCase;
        assert (firstCharCase != null);
        this.firstCase = firstCharCase;
        assert (wordStartCharCase != null);
        this.wordStartCase = wordStartCharCase;
        if (example == null) {
            assert (!register);
            this.example = this.createExample();
        } else {
            this.example = example;
        }
        if (register) {
            CONSTANTS.add(this);
        }
    }

    public Character getWordSeparator() {
        return this.wordSeparator;
    }

    public boolean hasWordSeparator() {
        return this.wordSeparator != null && !KEEP_SPECIAL_CHARS.equals(this.wordSeparator);
    }

    public CaseConversion getFirstCase() {
        return this.firstCase;
    }

    public CaseConversion getWordStartCase() {
        return this.wordStartCase;
    }

    public CaseConversion getOtherCase() {
        return this.otherCase;
    }

    public String convert(String string) {
        return this.convert(string, null);
    }

    public String convert(String string, Locale locale) {
        int start;
        if (string == null || string.isEmpty()) {
            return string;
        }
        if (!this.hasWordSeparator() && this.wordStartCase == this.otherCase) {
            String s = string;
            if (this.wordSeparator == null) {
                s = CaseSyntax.removeSpecialCharacters(s);
            }
            if (this.firstCase == this.wordStartCase) {
                s = this.firstCase.convert(s, locale);
            } else {
                String first = this.firstCase.convert(s.substring(0, 1), locale);
                String rest = this.otherCase.convert(s.substring(1), locale);
                s = first + rest;
            }
            return s;
        }
        SequenceCharIterator charIterator = new SequenceCharIterator(string);
        StringBuilder buffer = new StringBuilder(string.length() + 4);
        char c = charIterator.next();
        CharClass previousClass = CharClass.of(c);
        while (previousClass.isSeparatorOrDollar()) {
            if (buffer.length() == 0 && this.hasWordSeparator()) {
                buffer.append(this.wordSeparator);
            }
            if (!charIterator.hasNext()) {
                return buffer.toString();
            }
            c = charIterator.next();
            previousClass = CharClass.of(c);
        }
        this.appendCasedChar(buffer, c, this.firstCase);
        CaseConversion previousCase = CaseConversion.ofExample(c, false);
        int end = start = 1;
        while (charIterator.hasNext()) {
            c = charIterator.next();
            CharClass currentClass = CharClass.of(c);
            CaseConversion currentCase = CaseConversion.ofExample(c, false);
            switch (currentClass) {
                case LETTER: {
                    if (previousClass.isSeparatorOrDollar()) {
                        this.appendCasedChar(buffer, c, this.wordStartCase);
                        ++start;
                        break;
                    }
                    if (currentCase == previousCase || currentCase != CaseConversion.UPPER_CASE || end <= 1) break;
                    assert (previousCase == CaseConversion.LOWER_CASE);
                    start = this.appendOthers(string, buffer, start, end);
                    if (this.hasWordSeparator()) {
                        buffer.append(this.wordSeparator);
                    }
                    this.appendCasedChar(buffer, c, this.wordStartCase);
                    break;
                }
                case SEPARATOR: 
                case DOLLAR: {
                    if (!previousClass.isSeparatorOrDollar()) {
                        start = this.appendOthers(string, buffer, start, end);
                        if (KEEP_SPECIAL_CHARS.equals(this.wordSeparator)) {
                            buffer.append(c);
                            break;
                        }
                        if (this.wordSeparator == null) break;
                        buffer.append(this.wordSeparator);
                        break;
                    }
                    ++start;
                    break;
                }
            }
            if (currentClass != CharClass.DIGIT) {
                previousClass = currentClass;
                previousCase = currentCase;
            }
            ++end;
        }
        if (start < end) {
            this.appendOthers(string, buffer, start, end);
        }
        return buffer.toString();
    }

    private int appendOthers(String string, StringBuilder buffer, int start, int end) {
        buffer.append(this.otherCase.convert(string.substring(start, end)));
        return end + 1;
    }

    private void appendCasedChar(StringBuilder buffer, char c, CaseConversion targetCase) {
        if (targetCase == CaseConversion.ORIGINAL_CASE) {
            buffer.append(c);
        } else {
            CaseConversion currentCase = CaseConversion.ofExample(c, false);
            if (currentCase == targetCase) {
                buffer.append(c);
            } else {
                String string = targetCase.convert(Character.toString(c));
                if (this.otherCase != targetCase && string.length() > 1) {
                    buffer.append(string.charAt(0));
                    CaseConversion restCase = this.otherCase == CaseConversion.ORIGINAL_CASE ? currentCase : this.otherCase;
                    buffer.append(restCase.convert(string.charAt(0)));
                } else {
                    buffer.append(string);
                }
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CaseSyntax other = (CaseSyntax)obj;
        if (!Objects.equals(this.wordSeparator, other.wordSeparator)) {
            return false;
        }
        if (this.firstCase != other.firstCase) {
            return false;
        }
        if (this.wordStartCase != other.wordStartCase) {
            return false;
        }
        return this.otherCase == other.otherCase;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.wordSeparator, this.firstCase, this.wordStartCase, this.otherCase});
    }

    public String toString() {
        return this.example;
    }

    public static CaseSyntax of(Character separator, CaseConversion allCharCase) {
        return CaseSyntax.of(separator, allCharCase, allCharCase, allCharCase);
    }

    public static CaseSyntax of(Character separator, CaseConversion firstCharCase, CaseConversion wordStartCharCase) {
        return CaseSyntax.of(separator, firstCharCase, wordStartCharCase, CaseConversion.LOWER_CASE);
    }

    public static CaseSyntax of(Character separator, CaseConversion firstCharCase, CaseConversion wordStartCharCase, CaseConversion otherCharCase) {
        CaseSyntax syntax = CaseSyntax.ofStandardized(separator, firstCharCase, wordStartCharCase, otherCharCase);
        if (syntax == null) {
            syntax = new CaseSyntax(separator, firstCharCase, wordStartCharCase, otherCharCase, null, false);
        }
        return syntax;
    }

    private String createExample() {
        StringBuilder buffer = new StringBuilder(11);
        buffer.append(this.firstCase.convert('C'));
        int i = 0;
        if (this.firstCase == CaseConversion.ORIGINAL_CASE) {
            buffer.insert(i, '$');
        } else {
            ++i;
        }
        if (this.wordStartCase == CaseConversion.ORIGINAL_CASE) {
            buffer.insert(i, '$');
        }
        if (this.otherCase == CaseConversion.ORIGINAL_CASE) {
            buffer.insert(i, '$');
        }
        buffer.append(this.otherCase.convert("ustom"));
        if (this.wordSeparator != null) {
            buffer.append(this.wordSeparator);
        }
        buffer.append(this.wordStartCase.convert('C'));
        buffer.append(this.otherCase.convert("ase"));
        String string = buffer.toString();
        return string;
    }

    private static CaseSyntax ofStandardized(Character separator, CaseConversion first, CaseConversion wordStart, CaseConversion other) {
        for (CaseSyntax syntax : CONSTANTS) {
            if (!Objects.equals(separator, syntax.wordSeparator) || first != syntax.firstCase || wordStart != syntax.wordStartCase || other != syntax.otherCase) continue;
            return syntax;
        }
        return null;
    }

    public static String normalizeExample(String example) {
        if (example == null) {
            return null;
        }
        return CaseConversion.LOWER_CASE.convert(CaseSyntax.removeSpecialCharacters(example));
    }

    private static String removeSpecialCharacters(String string) {
        return CaseSyntax.replaceSpecialCharacters(string, "");
    }

    private static String replaceSpecialCharacters(String string, String replacement) {
        return PATTERN_SPECIAL_CHARS.matcher(string).replaceAll(replacement);
    }

    public static CaseSyntax ofExample(String example, boolean standardize) {
        int letterOrDollarCount;
        Objects.requireNonNull(example, "example");
        SequenceCharIterator charIterator = new SequenceCharIterator(example);
        Character separator = null;
        CaseConversion other = null;
        CaseConversion wordStart = null;
        char c = charIterator.next();
        CaseConversion first = CaseConversion.ofExample(c, false);
        CharClass previousClass = CharClass.of(c);
        CaseConversion previousCase = first;
        char previousChar = c;
        int index = 0;
        int n = letterOrDollarCount = previousClass.isLetterOrDollar() ? 1 : 0;
        while (charIterator.hasNext()) {
            ++index;
            c = charIterator.next();
            CharClass currentClass = CharClass.of(c);
            CaseConversion currentCase = CaseConversion.ofExample(c, false);
            switch (currentClass) {
                case DOLLAR: {
                    ++letterOrDollarCount;
                    if (other == null && index < 3) {
                        other = CaseConversion.ORIGINAL_CASE;
                        break;
                    }
                    if (wordStart == null && index < 3) {
                        wordStart = CaseConversion.ORIGINAL_CASE;
                        break;
                    }
                    throw new IllegalArgumentException(example + ": the special character '" + '$' + "' is only allowed twice within the first three characters or three times at the beginning!");
                }
                case LETTER: {
                    ++letterOrDollarCount;
                    boolean wordStarted = false;
                    if (previousClass == CharClass.SEPARATOR) {
                        if (wordStart == null) {
                            wordStart = currentCase;
                        }
                        wordStarted = true;
                    } else if (other == null && wordStart == null) {
                        other = currentCase;
                    } else if (currentCase != previousCase && currentCase != other) {
                        if (wordStart == null) {
                            wordStart = currentCase;
                        }
                        wordStarted = true;
                    } else if (CaseConversion.areIncompatible(currentCase, other)) {
                        throw new IllegalArgumentException(example + ": the two characters '" + previousChar + c + "' both have case " + (Object)((Object)currentCase) + " but other case was detected as " + (Object)((Object)other) + "!");
                    }
                    if (!wordStarted || !CaseConversion.areIncompatible(currentCase, wordStart)) break;
                    throw new IllegalArgumentException(example + ": different word start cases " + (Object)((Object)wordStart) + " and " + (Object)((Object)currentCase) + "!");
                }
                case SEPARATOR: {
                    if (separator == null) {
                        if (wordStart != null) {
                            throw new IllegalArgumentException(example + ": word separator '" + c + "' detected but word start was already detected via case change!");
                        }
                        separator = Character.valueOf(c);
                        break;
                    }
                    if (c != separator.charValue()) {
                        throw new IllegalArgumentException(example + ": different word separators '" + separator + "' and '" + c + "'!");
                    }
                    if (previousClass != CharClass.SEPARATOR) break;
                    throw new IllegalArgumentException(example + ": duplicate word separators '" + separator + separator + "'!");
                }
            }
            if (currentClass != CharClass.DIGIT) {
                previousCase = currentCase;
                previousClass = currentClass;
            }
            previousChar = c;
        }
        if (letterOrDollarCount < 3) {
            throw new IllegalArgumentException(example + ": at least 3 letters are required!");
        }
        if (wordStart == null) {
            wordStart = other;
        } else if (other == null) {
            other = wordStart;
        }
        CaseSyntax syntax = null;
        if (standardize) {
            syntax = CaseSyntax.ofStandardized(separator, first, wordStart, other);
        }
        if (syntax == null) {
            syntax = new CaseSyntax(separator, first, wordStart, other, example, false);
        }
        return syntax;
    }

    private static enum CharClass {
        LETTER,
        DIGIT,
        DOLLAR,
        SEPARATOR;


        private boolean isSeparatorOrDollar() {
            return this == SEPARATOR || this == DOLLAR;
        }

        private boolean isLetterOrDollar() {
            return this == LETTER || this == DOLLAR;
        }

        private static CharClass of(char c) {
            if (Character.isLetter(c)) {
                return LETTER;
            }
            if (Character.isDigit(c)) {
                return DIGIT;
            }
            if (c == '$') {
                return DOLLAR;
            }
            return SEPARATOR;
        }
    }
}

