/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.exception.api;

import java.io.IOException;
import java.util.Locale;
import java.util.UUID;
import net.sf.mmm.util.exception.api.ExceptionTruncation;
import net.sf.mmm.util.exception.api.NlsRuntimeException;
import net.sf.mmm.util.exception.api.NlsThrowable;
import net.sf.mmm.util.exception.api.ThrowableHelper;
import net.sf.mmm.util.io.api.IoMode;
import net.sf.mmm.util.io.api.RuntimeIoException;
import net.sf.mmm.util.lang.api.StringUtil;
import net.sf.mmm.util.nls.api.NlsMessage;
import net.sf.mmm.util.uuid.api.UuidAccess;

public abstract class NlsException
extends Exception
implements NlsThrowable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final NlsMessage nlsMessage;
    private final UUID uuid;

    public NlsException(NlsMessage message) {
        this.nlsMessage = message;
        this.uuid = this.createUuid();
    }

    public NlsException(Throwable nested, NlsMessage message) {
        super(nested);
        this.nlsMessage = message;
        this.uuid = nested != null && nested instanceof NlsThrowable ? ((NlsThrowable)((Object)nested)).getUuid() : this.createUuid();
    }

    protected NlsException(NlsException copySource, ExceptionTruncation truncation) {
        super(null, truncation.isRemoveCause() ? null : copySource.getCause(), !truncation.isRemoveSuppressed(), !truncation.isRemoveStacktrace());
        this.nlsMessage = copySource.nlsMessage;
        this.uuid = copySource.uuid;
        if (!truncation.isRemoveStacktrace()) {
            this.setStackTrace(copySource.getStackTrace());
        }
        if (!truncation.isRemoveSuppressed()) {
            for (Throwable suppressed : copySource.getSuppressed()) {
                this.addSuppressed(suppressed);
            }
        }
    }

    protected UUID createUuid() {
        return UuidAccess.getFactory().createUuid();
    }

    @Override
    public final UUID getUuid() {
        return this.uuid;
    }

    @Override
    public final NlsMessage getNlsMessage() {
        return this.nlsMessage;
    }

    @Override
    public void printStackTrace(Locale locale, Appendable buffer) {
        NlsRuntimeException.printStackTrace(this, locale, buffer);
    }

    protected NlsRuntimeException createCopyViaClone(ExceptionTruncation truncation) {
        try {
            NlsRuntimeException copy = (NlsRuntimeException)this.clone();
            ThrowableHelper.removeDetails(copy, truncation);
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public NlsRuntimeException createCopy(ExceptionTruncation truncation) {
        return this.createCopyViaClone(truncation);
    }

    @Override
    public String getMessage() {
        StringBuilder buffer = new StringBuilder(this.getNlsMessage().getMessage());
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append(this.uuid);
        String code = this.getCode();
        if (!this.getClass().getSimpleName().equals(code)) {
            buffer.append(":");
            buffer.append(code);
        }
        return buffer.toString();
    }

    @Override
    public String getLocalizedMessage() {
        return this.getNlsMessage().getLocalizedMessage();
    }

    @Override
    public String getLocalizedMessage(Locale locale) {
        return this.getNlsMessage().getLocalizedMessage(locale);
    }

    @Override
    public void getLocalizedMessage(Locale locale, Appendable appendable) {
        this.getNlsMessage().getLocalizedMessage(locale, appendable);
    }

    @Override
    public NlsMessage toNlsMessage() {
        return this.getNlsMessage();
    }

    @Override
    public boolean isTechnical() {
        return false;
    }

    @Override
    public boolean isForUser() {
        return !this.isTechnical();
    }

    @Override
    public String getCode() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String toString() {
        return this.toString(Locale.getDefault(), null).toString();
    }

    @Override
    public String toString(Locale locale) {
        return this.toString(locale, null).toString();
    }

    @Override
    public Appendable toString(Locale locale, Appendable appendable) {
        Appendable buffer = appendable;
        if (buffer == null) {
            buffer = new StringBuilder(32);
        }
        try {
            Class<?> myClass = this.getClass();
            buffer.append(myClass.getName());
            buffer.append(": ");
            String code = this.getCode();
            if (!myClass.getSimpleName().equals(code)) {
                buffer.append(code);
                buffer.append(": ");
            }
            buffer.append(this.getLocalizedMessage(locale));
            if (this.uuid != null) {
                buffer.append(StringUtil.LINE_SEPARATOR);
                buffer.append(this.uuid.toString());
            }
            return buffer;
        }
        catch (IOException e) {
            throw new RuntimeIoException((Throwable)e, IoMode.WRITE);
        }
    }
}

