/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.component.impl;

import java.io.Closeable;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import net.sf.mmm.util.component.api.PeriodicRefresher;
import net.sf.mmm.util.component.api.Refreshable;
import net.sf.mmm.util.component.base.AbstractLoggableComponent;
import net.sf.mmm.util.concurrent.base.SimpleExecutor;
import net.sf.mmm.util.exception.api.NlsIllegalStateException;
import net.sf.mmm.util.exception.api.ValueOutOfRangeException;

public class PeriodicRefresherImpl
extends AbstractLoggableComponent
implements PeriodicRefresher,
Runnable,
Closeable {
    private static final int DEFAULT_REFRESH_DELAY_IN_SECONDS = 300;
    private static final Integer MIN_DELAY = 1;
    private Executor executor;
    private int refreshDelayInSeconds = 300;
    private boolean active;
    private volatile boolean shutdown = false;
    private Set<Refreshable> refreshableSet = new CopyOnWriteArraySet<Refreshable>();
    private Thread refreshThread;

    @Override
    protected void doInitialize() {
        super.doInitialize();
        if (this.executor == null) {
            this.executor = new SimpleExecutor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup() {
        if (this.shutdown) {
            throw new NlsIllegalStateException();
        }
        PeriodicRefresherImpl periodicRefresherImpl = this;
        synchronized (periodicRefresherImpl) {
            if (this.active) {
                return;
            }
            this.getLogger().info("starting " + this.getThreadName() + "...");
            Thread thread = new Thread(this);
            thread.setName(this.getThreadName());
            this.executor.execute(thread);
            this.active = true;
        }
    }

    @Override
    public void addRefreshable(Refreshable refreshable) {
        this.refreshableSet.add(refreshable);
        this.startup();
    }

    @Override
    public void removeRefreshable(Refreshable refreshable) {
        this.refreshableSet.remove(refreshable);
    }

    @Override
    @PreDestroy
    public void close() {
        this.shutdown = true;
        if (this.refreshThread != null) {
            this.refreshThread.interrupt();
        }
    }

    protected String getThreadName() {
        return PeriodicRefresherImpl.class.getSimpleName() + "-Thread";
    }

    @Override
    public void run() {
        this.refreshThread = Thread.currentThread();
        try {
            this.getLogger().info(this.getThreadName() + " started.");
            while (!this.shutdown) {
                long sleepTime = TimeUnit.SECONDS.toMillis(this.refreshDelayInSeconds);
                Thread.sleep(sleepTime);
                if (this.shutdown) continue;
                for (Refreshable engine : this.refreshableSet) {
                    engine.refresh();
                }
            }
            this.getLogger().info(this.getThreadName() + " ended.");
        }
        catch (InterruptedException e) {
            if (!this.shutdown) {
                this.getLogger().error("Illegal interrupt!", (Throwable)e);
            }
        }
        catch (RuntimeException e) {
            this.getLogger().error(this.getThreadName() + " crashed!", (Throwable)e);
        }
        this.active = false;
    }

    protected Executor getExecutor() {
        return this.executor;
    }

    @Inject
    public void setExecutor(Executor executor) {
        this.getInitializationState().requireNotInitilized();
        this.executor = executor;
    }

    public int getRefreshDelaySeconds() {
        return this.refreshDelayInSeconds;
    }

    public void setRefreshDelayInSeconds(int refreshDelayInSeconds) {
        ValueOutOfRangeException.checkRange(refreshDelayInSeconds, MIN_DELAY, Integer.MAX_VALUE, this.getClass().getSimpleName() + ".refreshDelayInSeconds");
        this.refreshDelayInSeconds = refreshDelayInSeconds;
    }
}

