/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.reflect.base;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.sf.mmm.util.exception.api.IllegalCaseException;
import net.sf.mmm.util.exception.api.NlsIllegalArgumentException;
import net.sf.mmm.util.exception.api.NlsNullPointerException;
import net.sf.mmm.util.exception.api.NlsParseException;
import net.sf.mmm.util.filter.api.CharFilter;
import net.sf.mmm.util.filter.api.Filter;
import net.sf.mmm.util.filter.base.ConstantFilter;
import net.sf.mmm.util.filter.base.ListCharFilter;
import net.sf.mmm.util.io.api.IoMode;
import net.sf.mmm.util.io.api.RuntimeIoException;
import net.sf.mmm.util.lang.api.Visitor;
import net.sf.mmm.util.reflect.api.ClassResolver;
import net.sf.mmm.util.reflect.api.GenericType;
import net.sf.mmm.util.reflect.api.ReflectionUtil;
import net.sf.mmm.util.reflect.base.ClassNameCollector;
import net.sf.mmm.util.reflect.base.GenericTypeBuilder;
import net.sf.mmm.util.reflect.base.GenericTypeVariable;
import net.sf.mmm.util.reflect.base.IllegalWildcardSequenceException;
import net.sf.mmm.util.reflect.base.ReflectionUtilLimitedImpl;
import net.sf.mmm.util.reflect.base.ResourceCollector;
import net.sf.mmm.util.reflect.base.ResourceNameCollector;
import net.sf.mmm.util.reflect.base.ResourceVisitor;
import net.sf.mmm.util.reflect.impl.GenericArrayTypeImpl;
import net.sf.mmm.util.reflect.impl.GenericTypeImpl;
import net.sf.mmm.util.reflect.impl.LowerBoundWildcardType;
import net.sf.mmm.util.reflect.impl.ParameterizedTypeImpl;
import net.sf.mmm.util.reflect.impl.SimpleGenericTypeImpl;
import net.sf.mmm.util.reflect.impl.UnboundedWildcardType;
import net.sf.mmm.util.reflect.impl.UpperBoundWildcardType;
import net.sf.mmm.util.resource.api.DataResource;
import net.sf.mmm.util.resource.base.UrlResource;
import net.sf.mmm.util.scanner.base.CharSequenceScanner;

public class ReflectionUtilImpl
extends ReflectionUtilLimitedImpl
implements ReflectionUtil {
    private static final String WEB_INF_CLASSES = "WEB-INF/classes/";
    private static ReflectionUtil instance;
    private static final CharFilter CHAR_FILTER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReflectionUtil getInstance() {
        if (instance != null) return instance;
        ReflectionUtilImpl impl = null;
        Class<ReflectionUtilImpl> clazz = ReflectionUtilImpl.class;
        synchronized (ReflectionUtilImpl.class) {
            if (instance == null) {
                impl = new ReflectionUtilImpl();
                instance = impl;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (impl == null) return instance;
            impl.initialize();
            return instance;
        }
    }

    @Override
    protected void doInitialized() {
        super.doInitialized();
        if (instance == null) {
            instance = this;
        }
    }

    @Override
    public Class<?>[] getClasses(Object[] objects) {
        Class[] result = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            result[i] = objects[i] == null ? null : objects[i].getClass();
        }
        return result;
    }

    @Override
    public <T> GenericType<T> createGenericType(Class<T> type) {
        return new SimpleGenericTypeImpl<T>(type);
    }

    @Override
    public GenericType<?> createGenericType(Type type) {
        if (type instanceof GenericType) {
            return (GenericType)type;
        }
        if (type instanceof Class) {
            return this.createGenericType((Class)type);
        }
        return new GenericTypeImpl(type);
    }

    @Override
    public GenericType<?> createGenericType(Type type, GenericType<?> definingType) {
        return new GenericTypeImpl(type, definingType);
    }

    @Override
    public GenericType<?> createGenericType(Type type, Class<?> definingType) {
        return this.createGenericType(type, this.createGenericType(definingType));
    }

    @Override
    public <E> GenericType<List<E>> createGenericTypeOfList(GenericType<E> elementType) {
        return new GenericTypeBuilder<List<E>>(){}.with(new GenericTypeVariable<E>(){}, elementType).build();
    }

    @Override
    public <K, V> GenericType<Map<K, V>> createGenericTypeOfMap(GenericType<K> keyType, GenericType<V> valueType) {
        return new GenericTypeBuilder<Map<K, V>>(){}.with(new GenericTypeVariable<K>(){}, keyType).with(new GenericTypeVariable<V>(){}, valueType).build();
    }

    @Override
    public <E> GenericType<Set<E>> createGenericTypeOfSet(GenericType<E> elementType) {
        return new GenericTypeBuilder<Set<E>>(){}.with(new GenericTypeVariable<E>(){}, elementType).build();
    }

    protected Class<?> getSubClass(Class<?> ancestor, Class<?> descendant) {
        if (ancestor == descendant) {
            return null;
        }
        if (!ancestor.isAssignableFrom(descendant)) {
            return null;
        }
        Class<?> child = descendant;
        if (ancestor.isInterface()) {
            block0: while (true) {
                Class<?>[] classArray = child.getInterfaces();
                int n = classArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block0;
                    Class<?> childInterface = classArray[n2];
                    if (childInterface == ancestor) {
                        return child;
                    }
                    if (ancestor.isAssignableFrom(childInterface)) {
                        child = childInterface;
                        continue block0;
                    }
                    ++n2;
                }
                break;
            }
        }
        Class<?> parent = child.getSuperclass();
        while (parent != ancestor) {
            child = parent;
            parent = child.getSuperclass();
        }
        return child;
    }

    protected Type getGenericDeclaration(Class<?> ancestor, Class<?> descendant) {
        if (ancestor == descendant) {
            return null;
        }
        if (!ancestor.isAssignableFrom(descendant)) {
            return null;
        }
        Class<?> child = descendant;
        if (ancestor.isInterface()) {
            block0: while (true) {
                Class<?>[] interfaces = child.getInterfaces();
                int i = 0;
                while (true) {
                    if (i >= interfaces.length) continue block0;
                    Class<?> childInterface = interfaces[i];
                    if (childInterface == ancestor) {
                        return child.getGenericInterfaces()[i];
                    }
                    if (ancestor.isAssignableFrom(childInterface)) {
                        child = childInterface;
                        continue block0;
                    }
                    ++i;
                }
                break;
            }
        }
        Class<?> parent = child.getSuperclass();
        while (parent != ancestor) {
            child = parent;
            parent = child.getSuperclass();
        }
        return child.getGenericSuperclass();
    }

    @Override
    public Class<?> getArrayClass(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    @Override
    public Type toType(String type) {
        return this.toType(type, ClassResolver.CLASS_FOR_NAME_RESOLVER);
    }

    @Override
    public Type toType(String type, ClassResolver resolver) {
        try {
            CharSequenceScanner parser = new CharSequenceScanner(type);
            Type result = this.toType(parser, resolver, null);
            parser.skipWhile(' ');
            if (parser.hasNext()) {
                throw new NlsIllegalArgumentException((Object)parser.read(Integer.MAX_VALUE));
            }
            return result;
        }
        catch (RuntimeException e) {
            throw new NlsParseException((Throwable)e, (Object)type, (Type)((Object)Type.class));
        }
    }

    private Type toType(CharSequenceScanner parser, ClassResolver resolver, Type owner) {
        Type result;
        block19: {
            parser.skipWhile(' ');
            char c = parser.forcePeek();
            if (c == '?') {
                Type result2;
                parser.next();
                int spaces = parser.skipWhile(' ');
                if (spaces > 0) {
                    boolean lowerBound;
                    String sequence = parser.readUntil(' ', false);
                    if ("super".equals(sequence)) {
                        lowerBound = false;
                    } else if ("extends".equals(sequence)) {
                        lowerBound = true;
                    } else {
                        throw new IllegalWildcardSequenceException(sequence);
                    }
                    Type bound = this.toType(parser, resolver, null);
                    result2 = lowerBound ? new UpperBoundWildcardType(bound) : new LowerBoundWildcardType(bound);
                } else {
                    result2 = UnboundedWildcardType.INSTANCE;
                }
                parser.skipWhile(' ');
                c = parser.forcePeek();
                if (c == '[') {
                    parser.next();
                    if (!parser.expect(']')) {
                        throw new NlsIllegalArgumentException((Object)"Illegal array!");
                    }
                    result2 = new GenericArrayTypeImpl(result2);
                }
                return result2;
            }
            String segment = parser.readWhile(CHAR_FILTER).trim();
            c = parser.forceNext();
            if (c == '[') {
                if (!parser.expect(']')) {
                    throw new NlsIllegalArgumentException((Object)"Illegal array!");
                }
                StringBuilder sb = new StringBuilder(segment.length() + 3);
                sb.append("[L");
                sb.append(segment);
                sb.append(";");
                result = resolver.resolveClass(sb.toString());
            } else {
                Class<?> segmentClass;
                result = segmentClass = resolver.resolveClass(segment);
                if (c == '<') {
                    char d;
                    ArrayList<Type> typeArgList = new ArrayList<Type>();
                    do {
                        Type arg = this.toType(parser, resolver, null);
                        typeArgList.add(arg);
                        d = parser.forceNext();
                        if (d != '>') continue;
                        Type[] typeArguments = typeArgList.toArray(new Type[typeArgList.size()]);
                        result = new ParameterizedTypeImpl(segmentClass, typeArguments, owner);
                        parser.skipWhile(' ');
                        d = parser.forcePeek();
                        if (d == '[') {
                            parser.next();
                            if (!parser.expect(']')) {
                                throw new IllegalArgumentException("Illegal array!");
                            }
                            result = new GenericArrayTypeImpl(result);
                        } else if (d == '.') {
                            parser.next();
                            result = this.toType(parser, resolver, result);
                        }
                        break block19;
                    } while (d == ',');
                    throw new IllegalArgumentException("Failed to parse!");
                }
                if (c != '\u0000') {
                    parser.stepBack();
                }
            }
        }
        return result;
    }

    @Override
    public String toString(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        return type.toString();
    }

    @Override
    public String toStringSimple(Type type) {
        final StringBuilder buffer = new StringBuilder();
        Visitor formatter = new Visitor<Class<?>>(){

            @Override
            public void visit(Class<?> clazz) {
                buffer.append(clazz.getSimpleName());
            }
        };
        this.toString(type, buffer, formatter);
        return buffer.toString();
    }

    @Override
    public void toString(Type type, Appendable appendable, Visitor<Class<?>> classFormatter) {
        block16: {
            NlsNullPointerException.checkNotNull(Type.class, type);
            NlsNullPointerException.checkNotNull(Appendable.class, appendable);
            NlsNullPointerException.checkNotNull(Visitor.class, classFormatter);
            try {
                Type actualType = type;
                if (type instanceof GenericType) {
                    actualType = ((GenericType)type).getType();
                }
                if (actualType instanceof Class) {
                    classFormatter.visit((Class)actualType);
                    break block16;
                }
                if (actualType instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)actualType;
                    Type ownerType = parameterizedType.getOwnerType();
                    if (ownerType != null) {
                        this.toString(ownerType, appendable, classFormatter);
                        appendable.append('.');
                    }
                    this.toString(parameterizedType.getRawType(), appendable, classFormatter);
                    appendable.append('<');
                    boolean separator = false;
                    for (Type arg : parameterizedType.getActualTypeArguments()) {
                        if (separator) {
                            appendable.append(", ");
                        }
                        this.toString(arg, appendable, classFormatter);
                        separator = true;
                    }
                    appendable.append('>');
                    break block16;
                }
                if (actualType instanceof TypeVariable) {
                    Type firstBound;
                    TypeVariable typeVariable = (TypeVariable)actualType;
                    appendable.append(typeVariable.getName());
                    Type[] bounds = typeVariable.getBounds();
                    if (bounds.length > 0 && !Object.class.equals((Object)(firstBound = bounds[0]))) {
                        appendable.append(" extends ");
                        this.toString(firstBound, appendable, classFormatter);
                    }
                    break block16;
                }
                if (actualType instanceof WildcardType) {
                    WildcardType wildcardType = (WildcardType)actualType;
                    Type[] lowerBounds = wildcardType.getLowerBounds();
                    if (lowerBounds.length > 0) {
                        appendable.append("? super ");
                        this.toString(lowerBounds[0], appendable, classFormatter);
                    } else {
                        Type[] upperBounds = wildcardType.getUpperBounds();
                        if (upperBounds.length > 0) {
                            appendable.append("? extends ");
                            this.toString(upperBounds[0], appendable, classFormatter);
                        } else {
                            appendable.append("?");
                        }
                    }
                    break block16;
                }
                if (actualType instanceof GenericArrayType) {
                    this.toString(((GenericArrayType)actualType).getGenericComponentType(), appendable, classFormatter);
                    appendable.append("[]");
                    break block16;
                }
                throw new IllegalCaseException(type.getClass().getName());
            }
            catch (IOException e) {
                throw new RuntimeIoException((Throwable)e, IoMode.WRITE);
            }
        }
    }

    @Override
    public int compare(Class<?> class1, Class<?> class2) {
        if (class1.equals(class2)) {
            return 0;
        }
        if (class1.isAssignableFrom(class2)) {
            return -1;
        }
        if (class2.isAssignableFrom(class1)) {
            return 1;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean isMarkerInterface(Class<?> interfaceClass) {
        if (Cloneable.class == interfaceClass) {
            return true;
        }
        if (Serializable.class == interfaceClass) {
            return true;
        }
        return EventListener.class == interfaceClass;
    }

    @Override
    public <T> T getStaticField(Class<?> type, String fieldName, Class<T> fieldType, boolean exactTypeMatch, boolean mustBeFinal, boolean inherit) throws NoSuchFieldException, IllegalAccessException, IllegalArgumentException {
        Field field = type.getField(fieldName);
        int modifiers = field.getModifiers();
        if (!Modifier.isStatic(modifiers)) {
            throw new IllegalArgumentException("Field '" + fieldName + "' (in type '" + type + "') is not static!");
        }
        if (mustBeFinal && !Modifier.isFinal(modifiers)) {
            throw new IllegalArgumentException("Field '" + fieldName + "' (in type '" + type + "') is not final!");
        }
        Class<?> actualType = field.getType();
        boolean typeMismatch = false;
        if (exactTypeMatch) {
            typeMismatch = !actualType.equals(fieldType);
        } else {
            Class<?> actualObjectType = this.getNonPrimitiveType(actualType);
            Class<T> expectedObjectType = this.getNonPrimitiveType(fieldType);
            if (!expectedObjectType.isAssignableFrom(actualObjectType)) {
                typeMismatch = true;
            }
        }
        if (!inherit && field.getDeclaringClass() != type) {
            throw new NoSuchFieldException(fieldName);
        }
        if (typeMismatch) {
            throw new IllegalArgumentException("Field '" + fieldName + "' (in type '" + type + "') has type '" + field.getType() + "' but requested type was '" + fieldType + "'!");
        }
        return (T)field.get(null);
    }

    @Override
    public <T> T getStaticFieldOrNull(Class<?> type, String fieldName, Class<T> fieldType, boolean exactTypeMatch, boolean mustBeFinal, boolean inherit) throws IllegalArgumentException {
        try {
            return this.getStaticField(type, fieldName, fieldType, exactTypeMatch, mustBeFinal, inherit);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public Method getParentMethod(Method method) throws SecurityException {
        return this.getParentMethod(method.getDeclaringClass(), method.getName(), method.getParameterTypes());
    }

    @Override
    public Method getParentMethod(Class<?> inheritingClass, String methodName, Class<?>[] parameterTypes) throws SecurityException {
        int i;
        Class<?> parentClass = inheritingClass.getSuperclass();
        if (parentClass != null) {
            try {
                return parentClass.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        Class<?>[] interfaces = inheritingClass.getInterfaces();
        for (i = 0; i < interfaces.length; ++i) {
            try {
                return interfaces[i].getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        for (i = 0; i < interfaces.length; ++i) {
            Method result = this.getParentMethod(interfaces[i], methodName, parameterTypes);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static void visitResources(File packageDirectory, StringBuilder qualifiedNameBuilder, int qualifiedNamePrefixLength, ResourceVisitor visitor) {
        for (File childFile : packageDirectory.listFiles()) {
            String fileName = childFile.getName();
            qualifiedNameBuilder.setLength(qualifiedNamePrefixLength);
            if (childFile.isDirectory()) {
                StringBuilder subBuilder = new StringBuilder(qualifiedNameBuilder);
                subBuilder.append(fileName);
                subBuilder.append('/');
                if (!visitor.visitPackage(subBuilder.toString())) continue;
                ReflectionUtilImpl.visitResources(childFile, subBuilder, subBuilder.length(), visitor);
                continue;
            }
            qualifiedNameBuilder.append(fileName);
            visitor.visitResource(qualifiedNameBuilder.toString());
        }
    }

    @Override
    public Set<String> findClassNames(String packageName, boolean includeSubPackages) {
        HashSet<String> classSet = new HashSet<String>();
        this.findClassNames(packageName, includeSubPackages, classSet);
        return classSet;
    }

    @Override
    public void findClassNames(String packageName, boolean includeSubPackages, Set<String> classSet) {
        Filter filter = ConstantFilter.getInstance(true);
        this.findClassNames(packageName, includeSubPackages, classSet, filter, this.getDefaultClassLoader());
    }

    @Override
    public Set<String> findClassNames(String packageName, boolean includeSubPackages, Filter<? super String> filter) {
        HashSet<String> result = new HashSet<String>();
        this.findClassNames(packageName, includeSubPackages, result, filter, this.getDefaultClassLoader(filter.getClass()));
        return result;
    }

    @Override
    public Set<String> findClassNames(String packageName, boolean includeSubPackages, Filter<? super String> filter, ClassLoader classLoader) {
        HashSet<String> result = new HashSet<String>();
        this.findClassNames(packageName, includeSubPackages, result, filter, classLoader);
        return result;
    }

    protected void findClassNames(String packageName, boolean includeSubPackages, Set<String> classSet, Filter<? super String> filter, ClassLoader classLoader) throws RuntimeIoException {
        ClassNameCollector visitor = new ClassNameCollector(classSet, filter);
        this.visitResourceNames(packageName, includeSubPackages, classLoader, visitor);
    }

    @Override
    public Set<String> findResourceNames(String packageName, boolean includeSubPackages, Filter<? super String> filter) {
        return this.findResourceNames(packageName, includeSubPackages, filter, this.getDefaultClassLoader(filter.getClass()));
    }

    @Override
    public Set<String> findResourceNames(String packageName, boolean includeSubPackages, Filter<? super String> filter, ClassLoader classLoader) {
        HashSet<String> result = new HashSet<String>();
        ResourceNameCollector visitor = new ResourceNameCollector(result, filter);
        this.visitResourceNames(packageName, includeSubPackages, classLoader, visitor);
        return result;
    }

    @Override
    public Set<DataResource> findResources(String packageName, boolean includeSubPackages, Filter<? super String> filter) {
        return this.findResources(packageName, includeSubPackages, filter, this.getDefaultClassLoader(filter.getClass()));
    }

    @Override
    public Set<DataResource> findResources(String absoluteClasspath) throws RuntimeIoException {
        try {
            HashSet<DataResource> result = new HashSet<DataResource>();
            Enumeration<URL> resourceUrlEnumeration = this.getDefaultClassLoader().getResources(absoluteClasspath);
            while (resourceUrlEnumeration.hasMoreElements()) {
                URL url = resourceUrlEnumeration.nextElement();
                result.add(new UrlResource(url));
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeIoException((Throwable)e, IoMode.READ);
        }
    }

    @Override
    public Set<DataResource> findResources(String packageName, boolean includeSubPackages, Filter<? super String> filter, ClassLoader classLoader) {
        HashSet<DataResource> result = new HashSet<DataResource>();
        ResourceCollector visitor = new ResourceCollector(result, filter);
        this.visitResourceNames(packageName, includeSubPackages, classLoader, visitor);
        return result;
    }

    public void visitResourceNames(String packageName, boolean includeSubPackages, ClassLoader classLoader, ResourceVisitor visitor) throws RuntimeIoException {
        try {
            String path = packageName.replace('.', '/');
            String pathWithPrefix = path + '/';
            Enumeration<URL> urls = classLoader.getResources(path);
            StringBuilder qualifiedNameBuilder = new StringBuilder(path);
            if (qualifiedNameBuilder.length() > 0) {
                qualifiedNameBuilder.append('/');
            }
            int qualifiedNamePrefixLength = qualifiedNameBuilder.length();
            while (urls.hasMoreElements()) {
                URL packageUrl = urls.nextElement();
                String protocol = packageUrl.getProtocol().toLowerCase();
                if ("file".equals(protocol)) {
                    String urlString = URLDecoder.decode(packageUrl.getFile(), "UTF-8");
                    File packageDirectory = new File(urlString);
                    if (!packageDirectory.isDirectory()) continue;
                    if (includeSubPackages) {
                        ReflectionUtilImpl.visitResources(packageDirectory, qualifiedNameBuilder, qualifiedNamePrefixLength, visitor);
                        continue;
                    }
                    for (File child : packageDirectory.listFiles()) {
                        if (!child.isFile()) continue;
                        qualifiedNameBuilder.setLength(qualifiedNamePrefixLength);
                        qualifiedNameBuilder.append(child.getName());
                        visitor.visitResource(qualifiedNameBuilder.toString());
                    }
                    continue;
                }
                if ("jar".equals(protocol)) {
                    JarURLConnection connection = (JarURLConnection)packageUrl.openConnection();
                    JarFile jarFile = connection.getJarFile();
                    Enumeration<JarEntry> jarEntryEnumeration = jarFile.entries();
                    while (jarEntryEnumeration.hasMoreElements()) {
                        int index;
                        JarEntry jarEntry = jarEntryEnumeration.nextElement();
                        String classpath = jarEntry.getName();
                        if (classpath.startsWith("/")) {
                            classpath = classpath.substring(1);
                        }
                        if (classpath.startsWith(WEB_INF_CLASSES)) {
                            classpath = classpath.substring(WEB_INF_CLASSES.length());
                        }
                        if (!classpath.startsWith(pathWithPrefix)) continue;
                        boolean accept = true;
                        if (!includeSubPackages && (index = classpath.indexOf(47, qualifiedNamePrefixLength + 1)) != -1) {
                            accept = false;
                        }
                        if (!accept) continue;
                        if (jarEntry.isDirectory()) {
                            visitor.visitPackage(classpath);
                            continue;
                        }
                        visitor.visitResource(classpath);
                    }
                    continue;
                }
                this.getLogger().warn("Unknown protocol '" + protocol + "' in classpath entry!");
            }
        }
        catch (IOException e) {
            throw new RuntimeIoException((Throwable)e, IoMode.READ);
        }
    }

    @Override
    public Set<Class<?>> loadClasses(Collection<String> qualifiedClassNames) {
        return this.loadClasses(qualifiedClassNames, ClassResolver.CLASS_FOR_NAME_RESOLVER, ConstantFilter.getInstance(true));
    }

    @Override
    public Set<Class<?>> loadClasses(Collection<String> qualifiedClassNames, Filter<? super Class<?>> filter) {
        return this.loadClasses(qualifiedClassNames, ClassResolver.CLASS_FOR_NAME_RESOLVER, filter);
    }

    @Override
    public Set<Class<?>> loadClasses(Collection<String> classNames, ClassResolver classResolver, Filter<? super Class<?>> filter) {
        HashSet classesSet = new HashSet();
        for (String className : classNames) {
            try {
                Class<?> clazz = classResolver.resolveClass(className);
                if (!filter.accept(clazz)) continue;
                classesSet.add(clazz);
            }
            catch (Throwable e) {
                this.getLogger().warn("Failed to resolve class {}: {}", (Object)className, (Object)e.toString());
            }
        }
        return classesSet;
    }

    protected ClassLoader getDefaultClassLoader() {
        return this.getDefaultClassLoader(ReflectionUtilImpl.class);
    }

    protected ClassLoader getDefaultClassLoader(Class<?> fallbackClass) {
        ClassLoader result = Thread.currentThread().getContextClassLoader();
        if (result == null) {
            this.getLogger().warn("strange container: no context-class-loader available!");
            result = fallbackClass.getClassLoader();
            if (result == null) {
                this.getLogger().warn("strange JVM: only system-class-loader available!");
                result = ClassLoader.getSystemClassLoader();
            }
        }
        return result;
    }

    static {
        CHAR_FILTER = new ListCharFilter(false, '<', '[', ',', '?', '>');
    }
}

