/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.base;

import java.io.IOException;
import java.util.Locale;
import net.sf.mmm.util.io.api.IoMode;
import net.sf.mmm.util.io.api.RuntimeIoException;
import net.sf.mmm.util.lang.api.LocalizableFormatter;
import net.sf.mmm.util.lang.base.AbstractFormatter;

public abstract class AbstractLocalizableFormatter<V>
extends AbstractFormatter<V>
implements LocalizableFormatter<V> {
    protected Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    @Override
    public String format(V value) {
        return this.format(value, this.getDefaultLocale());
    }

    @Override
    public String format(V value, Locale locale) {
        StringBuilder buffer = new StringBuilder();
        this.format(value, buffer, locale);
        return buffer.toString();
    }

    @Override
    public void format(V value, Appendable buffer) {
        this.format(value, buffer, this.getDefaultLocale());
    }

    @Override
    public void format(V value, Appendable buffer, Locale locale) throws RuntimeIoException {
        try {
            if (value == null) {
                buffer.append(this.formatNull());
            } else {
                this.doFormat(value, buffer, locale);
            }
        }
        catch (IOException e) {
            throw new RuntimeIoException((Throwable)e, IoMode.WRITE);
        }
    }

    protected abstract void doFormat(V var1, Appendable var2, Locale var3) throws IOException;

    @Override
    protected void doFormat(V value, Appendable buffer) throws IOException {
        this.doFormat(value, buffer, this.getDefaultLocale());
    }
}

