/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.api;

import java.util.Iterator;
import net.sf.mmm.util.collection.base.AbstractIterator;
import net.sf.mmm.util.exception.api.NlsIllegalArgumentException;
import net.sf.mmm.util.exception.api.NlsParseException;

public class StringTokenizer
extends AbstractIterator<String>
implements Iterable<String> {
    private final char[] string;
    private final char[] delimiters;
    private final char[] escapeStart;
    private final char[] escapeEnd;
    private int index;

    public StringTokenizer(String string, char ... delimiters) {
        this(string.toCharArray(), delimiters);
    }

    public StringTokenizer(String string, String delimiters) {
        this(string.toCharArray(), delimiters.toCharArray());
    }

    public StringTokenizer(String string, String escapeStart, String escapeEnd, char ... delimiters) throws NlsIllegalArgumentException {
        this(string.toCharArray(), escapeStart, escapeEnd, delimiters);
    }

    public StringTokenizer(char[] string, String escapeStart, String escapeEnd, char ... delimiters) throws NlsIllegalArgumentException {
        this.string = string;
        this.delimiters = delimiters;
        if (escapeStart == null) {
            if (escapeEnd != null) {
                throw new NlsIllegalArgumentException((Object)escapeEnd, "escapeEnd (escapeStart=null)");
            }
            this.escapeStart = null;
            this.escapeEnd = null;
        } else {
            if (escapeStart.equals(escapeEnd)) {
                throw new NlsIllegalArgumentException((Object)escapeEnd, "escapeStart=escapeEnd");
            }
            if (escapeStart.length() == 0) {
                throw new NlsIllegalArgumentException((Object)escapeStart, "escapeStart");
            }
            if (escapeEnd == null || escapeEnd.length() == 0) {
                throw new NlsIllegalArgumentException((Object)escapeEnd, "escapeEnd");
            }
            this.escapeStart = escapeStart.toCharArray();
            this.escapeEnd = escapeEnd.toCharArray();
            if (StringTokenizer.containsDelimiter(this.escapeStart, delimiters)) {
                throw new NlsIllegalArgumentException((Object)escapeStart, "escapeStart");
            }
            if (StringTokenizer.containsDelimiter(this.escapeEnd, delimiters)) {
                throw new NlsIllegalArgumentException((Object)escapeEnd, "escapeEnd");
            }
        }
        this.index = -1;
        this.findFirst();
    }

    public StringTokenizer(char[] string, char ... delimiters) {
        this(string, null, null, delimiters);
    }

    private static boolean containsDelimiter(char[] escape, char[] delimiters) {
        for (char c : escape) {
            for (char d : delimiters) {
                if (d != c) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    @Override
    protected String findNext() {
        int end;
        int start;
        if (this.index >= this.string.length || this.string.length == 0) {
            return null;
        }
        ++this.index;
        if (this.escapeStart != null && this.containsSubstring(this.escapeStart, this.index)) {
            int rawStart = this.index;
            this.index += this.escapeStart.length;
            end = start = this.index;
            int escapeDeepth = 1;
            while (this.index < this.string.length) {
                if (this.containsSubstring(this.escapeStart, this.index)) {
                    ++escapeDeepth;
                    this.index += this.escapeStart.length;
                    continue;
                }
                if (this.escapeEnd != null && this.containsSubstring(this.escapeEnd, this.index)) {
                    if (--escapeDeepth == 0) {
                        end = this.index;
                        this.index += this.escapeEnd.length;
                        break;
                    }
                    this.index += this.escapeEnd.length;
                    continue;
                }
                ++this.index;
            }
            if (escapeDeepth != 0) {
                StringBuilder format = new StringBuilder();
                format.append(this.escapeStart);
                format.append('*');
                format.append(this.escapeEnd);
                throw new NlsParseException(new String(this.string, rawStart, this.index - rawStart), (CharSequence)format, (Object)"token");
            }
            if (this.index < this.string.length) {
                char c = this.string[this.index];
                boolean isDelimiter = false;
                for (char delimiter : this.delimiters) {
                    if (c != delimiter) continue;
                    isDelimiter = true;
                    break;
                }
                if (!isDelimiter) {
                    throw new NlsParseException(new String(this.string, rawStart, this.index + 1 - rawStart), (CharSequence)(new String(this.escapeEnd) + this.delimiters[0]), (Object)"token");
                }
            }
        } else {
            start = this.index;
            while (this.index < this.string.length) {
                char c = this.string[this.index];
                boolean isDelimiter = false;
                for (char delimiter : this.delimiters) {
                    if (c != delimiter) continue;
                    isDelimiter = true;
                    break;
                }
                if (isDelimiter) break;
                ++this.index;
            }
            end = this.index;
        }
        return new String(this.string, start, end - start);
    }

    protected boolean containsSubstring(char[] substring, int startIndex) {
        if (substring.length < this.string.length - startIndex) {
            for (int i = 0; i < substring.length; ++i) {
                if (substring[i] == this.string[startIndex + i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean hasMoreTokens() {
        return this.hasNext();
    }

    public String nextToken() {
        return (String)this.next();
    }

    public String toString() {
        if (this.index < this.string.length) {
            return new String(this.string, this.index, this.string.length - this.index);
        }
        return "";
    }
}

