/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.filter.base;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.mmm.util.filter.api.FilterRule;
import net.sf.mmm.util.filter.base.FilterRuleChain;
import net.sf.mmm.util.filter.base.PatternFilterRule;
import net.sf.mmm.util.xml.api.DomUtil;
import net.sf.mmm.util.xml.base.DomUtilImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FilterRuleChainXmlParser {
    public static final String XML_TAG_CHAIN = "filter-chain";
    public static final String XML_ATR_CHAIN_ID = "id";
    public static final String XML_ATR_CHAIN_PARENT = "parent";
    public static final String XML_ATR_CHAIN_DEFAULT = "default-result";
    public static final String XML_TAG_RULE_INCLUDE = "include";
    public static final String XML_TAG_RULE_EXCLUDE = "exclude";
    public static final String XML_ATR_RULE_PATTERN = "pattern";
    private final DomUtil domUtil;

    public FilterRuleChainXmlParser() {
        this(DomUtilImpl.getInstance());
    }

    public FilterRuleChainXmlParser(DomUtil domUtil) {
        this.domUtil = domUtil;
    }

    public FilterRuleChain<String> parseChain(InputStream inStream) throws IOException, SAXException {
        try {
            Document xmlDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inStream);
            FilterRuleChain<String> filterRuleChain = this.parseChain(xmlDoc.getDocumentElement());
            return filterRuleChain;
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("XML configuration error!", e);
        }
        finally {
            inStream.close();
        }
    }

    public Map<String, FilterRuleChain<String>> parseChains(Element xmlElement) {
        HashMap<String, FilterRuleChain<String>> chainMap = new HashMap<String, FilterRuleChain<String>>();
        NodeList childNodes = xmlElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String parentId;
            Element element;
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1 || !XML_TAG_CHAIN.equals((element = (Element)child).getTagName())) continue;
            String id = element.getAttribute(XML_ATR_CHAIN_ID);
            FilterRuleChain parent = null;
            if (element.hasAttribute(XML_ATR_CHAIN_PARENT) && (parent = (FilterRuleChain)chainMap.get(parentId = element.getAttribute(XML_ATR_CHAIN_PARENT))) == null) {
                throw new IllegalArgumentException("Illegal parent (" + parentId + ") in chain (" + id + "): parent chain has to be defined before being referenced!");
            }
            FilterRuleChain<String> chain = this.parseChain(element, parent);
            FilterRuleChain<String> old = chainMap.put(id, chain);
            if (old == null) continue;
            throw new IllegalArgumentException("Duplicate chain id: " + id);
        }
        return chainMap;
    }

    public FilterRuleChain<String> parseChain(Element xmlElement) {
        return this.parseChain(xmlElement, null);
    }

    public FilterRuleChain<String> parseChain(Element xmlElement, FilterRuleChain<String> parent) {
        boolean defaultResult = this.domUtil.getAttributeAsBoolean(xmlElement, XML_ATR_CHAIN_DEFAULT, true);
        ArrayList<PatternFilterRule> rules = new ArrayList<PatternFilterRule>();
        NodeList childList = xmlElement.getChildNodes();
        for (int childIndex = 0; childIndex < childList.getLength(); ++childIndex) {
            Node node = childList.item(childIndex);
            if (node.getNodeType() != 1) continue;
            Element child = (Element)node;
            Boolean include = null;
            if (child.getTagName().equals(XML_TAG_RULE_INCLUDE)) {
                include = Boolean.TRUE;
            } else if (child.getTagName().equals(XML_TAG_RULE_EXCLUDE)) {
                include = Boolean.FALSE;
            }
            if (include == null) continue;
            PatternFilterRule rule = null;
            if (child.hasAttribute(XML_ATR_RULE_PATTERN)) {
                String pattern = child.getAttribute(XML_ATR_RULE_PATTERN);
                rule = new PatternFilterRule(pattern, (boolean)include);
            }
            if (rule == null) continue;
            rules.add(rule);
        }
        if (rules.size() == 0) {
            throw new IllegalArgumentException("No rule found in element '" + xmlElement.getTagName() + "'!");
        }
        FilterRule[] ruleArray = rules.toArray(new FilterRule[rules.size()]);
        FilterRuleChain<String> chain = parent == null ? new FilterRuleChain(defaultResult, ruleArray) : parent.extend(defaultResult, ruleArray);
        return chain;
    }
}

