/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.filter.base;

import net.sf.mmm.util.exception.api.IllegalCaseException;
import net.sf.mmm.util.filter.api.CharFilter;
import net.sf.mmm.util.lang.api.Conjunction;

public class ConjunctionCharFilter
implements CharFilter {
    private final CharFilter[] filterList;
    private final Conjunction conjunction;

    public ConjunctionCharFilter(Conjunction conjunction, CharFilter ... filters) {
        assert (conjunction != null);
        this.filterList = filters;
        this.conjunction = conjunction;
    }

    @Override
    public boolean accept(char c) {
        block10: for (CharFilter filter : this.filterList) {
            boolean accept = filter.accept(c);
            switch (this.conjunction) {
                case OR: {
                    if (!accept) continue block10;
                    return true;
                }
                case AND: {
                    if (accept) continue block10;
                    return false;
                }
                case NOR: {
                    if (!accept) continue block10;
                    return false;
                }
                case NAND: {
                    if (accept) continue block10;
                    return true;
                }
                default: {
                    throw new IllegalCaseException(Conjunction.class, this.conjunction);
                }
            }
        }
        switch (this.conjunction) {
            case OR: 
            case NAND: {
                return false;
            }
            case AND: 
            case NOR: {
                return true;
            }
        }
        throw new IllegalCaseException(Conjunction.class, this.conjunction);
    }
}

