/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.converter;

import ma.glasnost.orika.Converter;
import ma.glasnost.orika.CustomConverter;
import ma.glasnost.orika.MapperFacade;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;

public abstract class BidirectionalConverter<S, D>
extends CustomConverter<Object, Object>
implements Converter<Object, Object> {
    private volatile Reversed<D, S> reversed;

    public abstract D convertTo(S var1, Type<D> var2, MappingContext var3);

    public abstract S convertFrom(D var1, Type<S> var2, MappingContext var3);

    @Override
    public Object convert(Object source, Type<? extends Object> destinationType, MappingContext mappingContext) {
        if (this.destinationType.isAssignableFrom(destinationType) || this.destinationType.isWrapperFor(destinationType) || this.destinationType.isPrimitiveFor(destinationType)) {
            return this.convertTo(source, destinationType, mappingContext);
        }
        return this.convertFrom(source, destinationType, mappingContext);
    }

    @Override
    public boolean canConvert(Type<?> sourceType, Type<?> destinationType) {
        return super.canConvert(sourceType, destinationType) || super.canConvert(destinationType, sourceType);
    }

    @Override
    public String toString() {
        String subClass = this.getClass().equals(BidirectionalConverter.class) || this.getClass().isAnonymousClass() ? "" : "(" + this.getClass().getSimpleName() + ")";
        String srcName = TypeFactory.nameOf(this.sourceType, this.destinationType);
        String dstName = TypeFactory.nameOf(this.destinationType, this.sourceType);
        return BidirectionalConverter.class.getSimpleName() + subClass + "<" + srcName + ", " + dstName + ">";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BidirectionalConverter<D, S> reverse() {
        if (this.reversed == null) {
            BidirectionalConverter bidirectionalConverter = this;
            synchronized (bidirectionalConverter) {
                if (this.reversed == null) {
                    this.reversed = new Reversed(this);
                }
            }
        }
        return this.reversed;
    }

    public static class Reversed<S, D>
    extends BidirectionalConverter<S, D> {
        private final BidirectionalConverter<D, S> delegate;

        public Reversed(BidirectionalConverter<D, S> bidi) {
            this.delegate = bidi;
        }

        @Override
        public D convertTo(S source, Type<D> destinationType, MappingContext mappingContext) {
            return this.delegate.convertFrom(source, destinationType, mappingContext);
        }

        @Override
        public S convertFrom(D source, Type<S> destinationType, MappingContext mappingContext) {
            return this.delegate.convertTo(source, destinationType, mappingContext);
        }

        @Override
        public BidirectionalConverter<D, S> reverse() {
            return this.delegate;
        }

        @Override
        public boolean canConvert(Type<?> sourceType, Type<?> destinationType) {
            return this.delegate.canConvert(sourceType, destinationType);
        }

        @Override
        public void setMapperFacade(MapperFacade mapper) {
            this.delegate.setMapperFacade(mapper);
        }

        @Override
        public Type<Object> getAType() {
            return this.delegate.getBType();
        }

        @Override
        public Type<Object> getBType() {
            return this.delegate.getAType();
        }

        @Override
        public String toString() {
            String subClass = this.delegate.getClass().equals(BidirectionalConverter.class) || this.delegate.getClass().isAnonymousClass() ? "" : "(" + this.delegate.getClass().getSimpleName() + ")";
            String srcName = TypeFactory.nameOf(this.delegate.getBType(), this.delegate.getAType());
            String dstName = TypeFactory.nameOf(this.delegate.getAType(), this.delegate.getBType());
            return BidirectionalConverter.class.getSimpleName() + subClass + "." + Reversed.class.getSimpleName() + "<" + srcName + ", " + dstName + ">";
        }
    }
}

