/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna.notification;

import android.app.Notification;
import android.content.Context;
import android.service.notification.StatusBarNotification;
import android.text.SpannableString;
import com.devicenative.dna.db.DNADatabaseInterface;
import com.devicenative.dna.utils.DNALogger;

public class DNANotificationListener {
    public void onNotificationPosted(Context context, StatusBarNotification sbn) {
        if (this.isNotificationTrivial(sbn)) {
            return;
        }
        String packageName = sbn.getPackageName();
        String title = sbn.getNotification().extras.getString("android.title");
        Object textObj = sbn.getNotification().extras.get("android.text");
        if (title == null || title.isEmpty()) {
            return;
        }
        String text = "";
        if (textObj != null) {
            text = textObj instanceof SpannableString ? textObj.toString() : (textObj instanceof String ? (String)textObj : textObj.toString());
        }
        DNALogger.i("DNANotificationListener: onNotificationPosted: " + packageName + ", " + title + ", " + text);
        DNADatabaseInterface.insertNotifRecord(context, title, text, packageName);
        DNADatabaseInterface.pruneNotifsRecords(context);
    }

    public boolean isNotificationTrivial(StatusBarNotification sbn) {
        Notification notification = sbn.getNotification();
        return notification.priority <= -2 || (notification.flags & 2) != 0 || this.isGroupHeader(notification);
    }

    private boolean isGroupHeader(Notification notification) {
        return (notification.flags & 0x200) != 0;
    }
}

