/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna.network;

import android.content.Context;
import com.devicenative.dna.network.DNANetworkInterfaceHTTPConnection;
import com.devicenative.dna.network.DNANetworkRequestStats;
import com.devicenative.dna.network.DNANetworkResponse;
import com.devicenative.dna.utils.DNALogger;
import org.json.JSONObject;

public class DNAStatSyncExecutor {
    private DNANetworkRequestStats requestStats;

    public DNAStatSyncExecutor(Context context) {
        this.requestStats = new DNANetworkRequestStats(context);
    }

    public void execute() {
        long start;
        block5: {
            start = System.currentTimeMillis();
            this.requestStats.onPreExecute();
            DNANetworkInterfaceHTTPConnection httpConn = new DNANetworkInterfaceHTTPConnection();
            DNANetworkResponse response = httpConn.executePost(this.requestStats.getPost(), this.requestStats.getRequestUrl());
            if (response.getStatusCode() == 200) {
                try {
                    JSONObject body = response.getBody();
                    if (body.has("success") && !body.getBoolean("success")) {
                        this.requestStats.handleFailure(-116, body.getString("message"));
                        break block5;
                    }
                    this.requestStats.onRequestSucceeded(response);
                }
                catch (Exception e) {
                    DNALogger.e("DNAServerPOSTLoader: " + e.getMessage());
                    this.requestStats.handleFailure(-116, "No success or message fields in response. Something went wrong on the server.");
                }
            } else {
                this.requestStats.handleFailure(response.getStatusCode(), response.getMessage());
            }
        }
        long end = System.currentTimeMillis();
        DNALogger.i("DNAStatSyncExecutor: " + (end - start) + " milliseconds to complete network request");
    }
}

