/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna.network;

import android.content.Context;
import com.devicenative.dna.db.DNAAdRecord;
import com.devicenative.dna.db.DNADatabaseInterface;
import com.devicenative.dna.db.DNADatabaseQueue;
import com.devicenative.dna.db.DNAShortcutRecord;
import com.devicenative.dna.network.DNANetworkRequest;
import com.devicenative.dna.network.DNANetworkResponse;
import com.devicenative.dna.utils.DNALogger;
import com.devicenative.dna.utils.DNAPreferences;
import com.devicenative.dna.utils.DNAStatsLogger;
import com.devicenative.dna.utils.DNAUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DNANetworkRequestSync
extends DNANetworkRequest {
    long startTime;

    public DNANetworkRequestSync(Context context) {
        super(context, "sync");
        try {
            this.setPost(new JSONObject());
        }
        catch (JSONException ex) {
            DNALogger.e("DNANetworkRequestSync: " + ex.getMessage());
        }
    }

    @Override
    public void onPreExecute() {
        super.onPreExecute();
        this.startTime = System.currentTimeMillis();
        JSONObject postBody = new JSONObject();
        try {
            postBody.put("dK", (Object)this.prefHelper_.getDeviceKey());
            postBody.put("aV", (Object)this.prefHelper_.getAppVersion());
            postBody.put("pN", (Object)this.prefHelper_.getAppPackageName());
            postBody.put("sV", (Object)"moto-v1.4.12");
            postBody.put("oV", (Object)this.prefHelper_.getAndroidVersion());
            postBody.put("dM", (Object)this.prefHelper_.getDeviceModel());
            postBody.put("cA", (Object)this.prefHelper_.getCarrierValue());
            postBody.put("lST", this.prefHelper_.getLastApiSyncTime());
            postBody.put("b", this.prefHelper_.getDeviceStartTime());
            postBody.put("c", this.prefHelper_.getCPUCount());
            postBody.put("m", this.prefHelper_.getMaxMemory());
            postBody.put("sId", (Object)this.prefHelper_.getSessionID());
            postBody.put("cVK", (Object)this.prefHelper_.getCodeVersionID());
            postBody.put("aVK", (Object)this.prefHelper_.getAdBundleID());
            postBody.put("mVK", (Object)this.prefHelper_.getMetadataVersionID());
            postBody.put("bVK", (Object)this.prefHelper_.getBlacklistVersionID());
            if (this.prefHelper_.getConfigCountryOverride() != null && !this.prefHelper_.getConfigCountryOverride().isEmpty()) {
                postBody.put("co", (Object)this.prefHelper_.getConfigCountryOverride());
            }
            postBody.put("cGD", this.prefHelper_.getConfigGAIDDisabled());
            postBody.put("cUD", this.prefHelper_.getConfigAppUsageDisabled());
            postBody.put("cAdD", this.prefHelper_.getConfigAdsDisabled());
            postBody.put("cSA", this.prefHelper_.getSearchAdsDisabled());
            postBody.put("cSI", this.prefHelper_.getSearchInstallAdsDisabled());
            postBody.put("cRA", this.prefHelper_.getRecomAdsDisabled());
            postBody.put("cRI", this.prefHelper_.getRecomInstallAdsDisabled());
            DNALogger.i("DNANetworkRequestSync: onPreExecute: " + postBody);
            this.setPost(postBody);
        }
        catch (JSONException ex) {
            DNALogger.e("DNANetworkRequestSync: " + ex.getMessage());
        }
    }

    @Override
    public void onRequestSucceeded(DNANetworkResponse resp) {
        DNADatabaseQueue.enqueue((Context)this.context_.get(), () -> this.processSyncResponse(resp));
    }

    private void processSyncResponse(DNANetworkResponse resp) {
        try {
            JSONArray adsList;
            JSONObject respJson = resp.getBody();
            String currCodeVersion = this.prefHelper_.getCodeVersionID();
            String currAdBundleID = this.prefHelper_.getAdBundleID();
            int numAdsAdded = 0;
            int numAdsUpdated = 0;
            int numAdsDeleted = 0;
            int numShortcutsAdded = 0;
            int numShortcutsDeleted = 0;
            if (respJson.has("cfg")) {
                JSONObject config = respJson.getJSONObject("cfg");
                if (config.has("rfI") && !config.isNull("rfI")) {
                    this.prefHelper_.setRefreshInterval(config.getInt("rfI"));
                }
                if (config.has("lrfI") && !config.isNull("lrfI")) {
                    this.prefHelper_.setLocalRefreshInterval(config.getInt("lrfI"));
                }
                if (config.has("aU") && !config.isNull("aU")) {
                    this.prefHelper_.setAPIUrl(config.getString("aU"));
                }
                if (config.has("cT") && !config.isNull("cT")) {
                    this.prefHelper_.setConnectTimeout(config.getInt("cT"));
                }
                if (config.has("nT") && !config.isNull("nT")) {
                    this.prefHelper_.setTimeout(config.getInt("nT"));
                }
                if (config.has("rtI") && !config.isNull("rtI")) {
                    this.prefHelper_.setRetryInterval(config.getInt("rtI"));
                }
                if (config.has("rC") && !config.isNull("rC")) {
                    this.prefHelper_.setRetryCount(config.getInt("rC"));
                }
                if (config.has("vta") && !config.isNull("vta")) {
                    this.prefHelper_.setVTAEnabled(config.getBoolean("vta"));
                }
                if (config.has("cpi") && !config.isNull("cpi")) {
                    this.prefHelper_.setInstallAdsEnabled(config.getBoolean("cpi"));
                }
                if (config.has("sad") && !config.isNull("sad")) {
                    this.prefHelper_.setSearchAdsDisabled(!config.getBoolean("sad"));
                }
                if (config.has("rad") && !config.isNull("rad")) {
                    this.prefHelper_.setRecomAdsDisabled(!config.getBoolean("rad"));
                }
                if (config.has("scpi") && !config.isNull("scpi")) {
                    this.prefHelper_.setSearchInstallAdsDisabled(!config.getBoolean("scpi"));
                }
                if (config.has("rcpi") && !config.isNull("rcpi")) {
                    this.prefHelper_.setRecomInstallAdsDisabled(!config.getBoolean("rcpi"));
                }
                if (config.has("web") && !config.isNull("web")) {
                    this.prefHelper_.setWebAdsEnabled(config.getBoolean("web"));
                }
                if (config.has("org") && !config.isNull("org")) {
                    this.prefHelper_.setOrganicAdsEnabled(config.getBoolean("org"));
                }
                if (config.has("orgO") && !config.isNull("orgO")) {
                    this.prefHelper_.setOrganicAdsOnly(config.getBoolean("orgO"));
                }
                if (config.has("orgB") && !config.isNull("orgB")) {
                    this.prefHelper_.setPaidOrganicBoostEnabled(config.getBoolean("orgB"));
                }
                if (config.has("iBW") && !config.isNull("iBW")) {
                    this.prefHelper_.setImpressionBlackoutWindow(config.getInt("iBW"));
                }
                if (config.has("aCT") && !config.isNull("aCT")) {
                    this.prefHelper_.setAdCacheTimeout(config.getInt("aCT"));
                }
                if (config.has("rGP") && !config.isNull("rGP")) {
                    this.prefHelper_.setReplaceGooglePlayUrl(config.getBoolean("rGP"));
                }
                if (config.has("gpU") && !config.isNull("gpU")) {
                    this.prefHelper_.setGooglePlayUrlReplacement(config.getString("gpU"));
                }
                if (config.has("aId") && !config.isNull("aId")) {
                    this.prefHelper_.setAdidUsageEnabled(config.getBoolean("aId"));
                }
                if (config.has("uD") && !config.isNull("uD")) {
                    this.prefHelper_.setAppUsageDisabled(config.getBoolean("uD"));
                }
                if (config.has("aDL") && !config.isNull("aDL")) {
                    this.prefHelper_.setAutoDeepLinkEnabled(config.getBoolean("aDL"));
                }
                if (this.prefHelper_.getAdidUsageEnabled() && this.prefHelper_.getAdid().isEmpty() && !this.prefHelper_.getConfigGAIDDisabled()) {
                    ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
                    scheduler.schedule(() -> {
                        try {
                            AdvertisingIdClient.Info adInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)((Context)this.context_.get()).getApplicationContext());
                            String adId = adInfo.getId();
                            if (adId != null && !adId.equals("00000000-0000-0000-0000-000000000000")) {
                                DNALogger.i("getAdvertisingId: direct Ad ID: " + adId);
                                this.prefHelper_.setAdid(adId);
                            } else {
                                Class<?> advertisingIdClientClass = Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
                                Class<?> adInfoClass = Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient$Info");
                                Object advertisingIdClient = advertisingIdClientClass.getMethod("getAdvertisingIdInfo", Context.class).invoke(null, this.context_.get());
                                adId = (String)adInfoClass.getMethod("getId", new Class[0]).invoke(advertisingIdClient, new Object[0]);
                                if (adId != null && !adId.equals("00000000-0000-0000-0000-000000000000")) {
                                    DNALogger.i("getAdvertisingId: reflection Ad ID: " + adId);
                                    this.prefHelper_.setAdid(adId);
                                }
                            }
                        }
                        catch (Exception e) {
                            DNALogger.i("getAdvertisingId: Failed to access Ad ID: " + e.getMessage());
                        }
                    }, 5L, TimeUnit.SECONDS);
                }
            }
            if (respJson.has("c") && respJson.get("c") instanceof String && !respJson.getString("c").isEmpty() && !respJson.getString("c").equals("null")) {
                this.prefHelper_.setAdSelectionCode(respJson.getString("c"));
            }
            if (respJson.has("cVK") && respJson.get("cVK") instanceof String && !respJson.getString("cVK").isEmpty() && !respJson.getString("cVK").equals("null")) {
                this.prefHelper_.setCodeVersionID(respJson.getString("cVK"));
            }
            if (respJson.has("a") && respJson.get("a") instanceof JSONArray) {
                adsList = respJson.getJSONArray("a");
                ArrayList<DNAAdRecord> adRecords = new ArrayList<DNAAdRecord>();
                for (int i = 0; i < adsList.length(); ++i) {
                    String adString = adsList.getString(i);
                    adRecords.add(new DNAAdRecord(new JSONObject(adString)));
                }
                DNADatabaseInterface.insertOrUpdateAdRecords((Context)this.context_.get(), adRecords);
                numAdsAdded = adRecords.size();
            }
            if (respJson.has("aUp") && respJson.get("aUp") instanceof JSONArray) {
                adsList = respJson.getJSONArray("aUp");
                DNADatabaseInterface.partialUpdateAdRecordsFromJSON((Context)this.context_.get(), adsList);
                numAdsUpdated = adsList.length();
            }
            if (respJson.has("aD") && respJson.get("aD") instanceof JSONArray) {
                JSONArray deleteAdsList = respJson.getJSONArray("aD");
                List<String> deleteAds = DNAUtils.convertJSONArrayToStrings(deleteAdsList);
                DNADatabaseInterface.deleteAdRecords((Context)this.context_.get(), deleteAds);
                numAdsDeleted = deleteAds.size();
            }
            if (respJson.has("aVK") && respJson.get("aVK") instanceof String && !respJson.getString("aVK").isEmpty() && !respJson.getString("aVK").equals("null")) {
                this.prefHelper_.setAdBundleID(respJson.getString("aVK"));
            }
            if (respJson.has("mVK") && respJson.get("mVK") instanceof String && !respJson.getString("mVK").isEmpty() && !respJson.getString("mVK").equals("null")) {
                this.prefHelper_.setMetadataVersionID(respJson.getString("mVK"));
            }
            if (respJson.has("bVK") && respJson.get("bVK") instanceof String && !respJson.getString("bVK").isEmpty() && !respJson.getString("bVK").equals("null")) {
                this.prefHelper_.setBlacklistVersionID(respJson.getString("bVK"));
            }
            if (respJson.has("b") && respJson.get("b") instanceof JSONArray) {
                JSONArray blacklistedPackages = respJson.getJSONArray("b");
                List<String> blacklistPs = DNAUtils.convertJSONArrayToStrings(blacklistedPackages);
                this.prefHelper_.setBlacklistPackages(blacklistPs);
            }
            if (respJson.has("sD") && respJson.get("sD") instanceof JSONArray) {
                JSONArray deleteShortcutList = respJson.getJSONArray("sD");
                List<String> deleteShortcuts = DNAUtils.convertJSONArrayToStrings(deleteShortcutList);
                DNADatabaseInterface.deleteShortcutRecords((Context)this.context_.get(), deleteShortcuts);
                numShortcutsDeleted = deleteShortcuts.size();
            }
            if (respJson.has("s") && respJson.get("s") instanceof JSONArray) {
                JSONArray sList = respJson.getJSONArray("s");
                ArrayList<DNAShortcutRecord> shortcutsList = new ArrayList<DNAShortcutRecord>();
                HashSet<String> affectedPackages = new HashSet<String>();
                for (int i = 0; i < sList.length(); ++i) {
                    JSONObject shortcutObject = sList.getJSONObject(i);
                    DNALogger.i("DNANetworkRequestSync: SHORTCUT: " + shortcutObject);
                    DNAShortcutRecord shortcutRecord = new DNAShortcutRecord(shortcutObject);
                    shortcutsList.add(shortcutRecord);
                    affectedPackages.add(shortcutRecord.packageName);
                }
                for (String packageName : affectedPackages) {
                    DNADatabaseInterface.removeShortcutsFromServer((Context)this.context_.get(), packageName);
                }
                DNADatabaseInterface.insertOrUpdateShortcutRecords((Context)this.context_.get(), shortcutsList);
                numShortcutsAdded = shortcutsList.size();
            }
            if (respJson.has("al") && respJson.get("al") instanceof JSONObject) {
                DNALogger.i("DNANetworkRequestSync: ALIAS_LIST: " + respJson.getJSONObject("al"));
                JSONObject aliasList = respJson.getJSONObject("al");
                DNADatabaseInterface.updateAliasesForApps((Context)this.context_.get(), aliasList);
            }
            this.prefHelper_.setLastApiSyncTime(System.currentTimeMillis());
            JSONObject statsMetadata = new JSONObject();
            try {
                statsMetadata.put("sId", (Object)this.prefHelper_.getSessionID());
                statsMetadata.put("status", 200);
                statsMetadata.put("numAdsAdded", numAdsAdded);
                statsMetadata.put("numAdsUpdated", numAdsUpdated);
                statsMetadata.put("numAdsDeleted", numAdsDeleted);
                statsMetadata.put("numShortcutsAdded", numShortcutsAdded);
                statsMetadata.put("numShortcutsDeleted", numShortcutsDeleted);
                statsMetadata.put("currCodeVersion", (Object)currCodeVersion);
                statsMetadata.put("currAdBundleID", (Object)currAdBundleID);
                statsMetadata.put("currMetadataVersion", (Object)this.prefHelper_.getMetadataVersionID());
                statsMetadata.put("currBlacklistVersion", (Object)this.prefHelper_.getBlacklistVersionID());
                statsMetadata.put("newCodeVersion", (Object)this.prefHelper_.getCodeVersionID());
                statsMetadata.put("newAdBundleID", (Object)this.prefHelper_.getAdBundleID());
            }
            catch (Exception je) {
                DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
            }
            long endTime = System.currentTimeMillis();
            DNAStatsLogger.logInternal((Context)this.context_.get(), "Server Sync", (int)(endTime - this.startTime), statsMetadata);
        }
        catch (Exception ex) {
            DNALogger.e("DNANetworkRequestSync: " + ex.getMessage());
        }
    }

    @Override
    public void handleFailure(int statusCode, String causeMsg) {
        DNALogger.e("DNANetworkRequestSync: handleFailure: " + statusCode + " : " + causeMsg);
        DNAPreferences prefs = DNAPreferences.getInstance((Context)this.context_.get());
        JSONObject statsMetadata = new JSONObject();
        try {
            statsMetadata.put("sId", (Object)prefs.getSessionID());
            statsMetadata.put("loc", (Object)"DNANetworkRequestSync.handleFailure");
            statsMetadata.put("m", (Object)causeMsg);
        }
        catch (Exception je) {
            DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
        }
        DNAStatsLogger.logInternal((Context)this.context_.get(), "Error", statusCode, statsMetadata);
    }

    @Override
    public boolean isGetRequest() {
        return true;
    }
}

