/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna.network;

import android.content.Context;
import com.devicenative.dna.db.DNADatabaseInterface;
import com.devicenative.dna.db.DNAEventRecord;
import com.devicenative.dna.network.DNANetworkRequest;
import com.devicenative.dna.network.DNANetworkResponse;
import com.devicenative.dna.utils.DNALogger;
import com.devicenative.dna.utils.DNAPreferences;
import com.devicenative.dna.utils.DNAStatsLogger;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DNANetworkRequestStats
extends DNANetworkRequest {
    long startTime;
    List<Long> statsIdsToDelete;

    public DNANetworkRequestStats(Context context) {
        super(context, "stats");
        try {
            this.setPost(new JSONObject());
        }
        catch (JSONException ex) {
            DNALogger.e("DNANetworkRequestSync: " + ex.getMessage());
        }
    }

    @Override
    public void onPreExecute() {
        super.onPreExecute();
        this.startTime = System.currentTimeMillis();
        JSONObject postBody = new JSONObject();
        try {
            postBody.put("dK", (Object)this.prefHelper_.getDeviceKey());
            postBody.put("aV", (Object)this.prefHelper_.getAppVersion());
            postBody.put("pN", (Object)this.prefHelper_.getAppPackageName());
            postBody.put("sV", (Object)"moto-v1.4.12");
            postBody.put("oV", (Object)this.prefHelper_.getAndroidVersion());
            postBody.put("dM", (Object)this.prefHelper_.getDeviceModel());
            postBody.put("cA", (Object)this.prefHelper_.getCarrierValue());
            postBody.put("lST", this.prefHelper_.getLastApiSyncTime());
            postBody.put("b", this.prefHelper_.getDeviceStartTime());
            postBody.put("c", this.prefHelper_.getCPUCount());
            postBody.put("m", this.prefHelper_.getMaxMemory());
            postBody.put("sId", (Object)this.prefHelper_.getSessionID());
            postBody.put("cVK", (Object)this.prefHelper_.getCodeVersionID());
            postBody.put("aVK", (Object)this.prefHelper_.getAdBundleID());
            postBody.put("mVK", (Object)this.prefHelper_.getMetadataVersionID());
            postBody.put("bVK", (Object)this.prefHelper_.getBlacklistVersionID());
            if (this.prefHelper_.getConfigCountryOverride() != null && !this.prefHelper_.getConfigCountryOverride().isEmpty()) {
                postBody.put("co", (Object)this.prefHelper_.getConfigCountryOverride());
            }
            postBody.put("cGD", this.prefHelper_.getConfigGAIDDisabled());
            postBody.put("cUD", this.prefHelper_.getConfigAppUsageDisabled());
            postBody.put("cAdD", this.prefHelper_.getConfigAdsDisabled());
            postBody.put("cSA", this.prefHelper_.getSearchAdsDisabled());
            postBody.put("cSI", this.prefHelper_.getSearchInstallAdsDisabled());
            postBody.put("cRA", this.prefHelper_.getRecomAdsDisabled());
            postBody.put("cRI", this.prefHelper_.getRecomInstallAdsDisabled());
            List<DNAEventRecord> eventRecords = DNADatabaseInterface.getAllStats((Context)this.context_.get());
            this.statsIdsToDelete = new ArrayList<Long>();
            JSONArray statsArray = new JSONArray();
            for (DNAEventRecord eventRecord : eventRecords) {
                statsArray.put((Object)eventRecord.getJSONObject());
                this.statsIdsToDelete.add(eventRecord.dbId);
            }
            postBody.put("s", (Object)statsArray);
            DNALogger.i("DNANetworkRequestSync: onPreExecute: " + postBody);
            this.setPost(postBody);
        }
        catch (JSONException ex) {
            DNALogger.e("DNANetworkRequestSync: " + ex.getMessage());
        }
    }

    @Override
    public void onRequestSucceeded(DNANetworkResponse resp) {
        try {
            DNADatabaseInterface.deleteStats((Context)this.context_.get(), this.statsIdsToDelete);
            JSONObject statsMetadata = new JSONObject();
            try {
                statsMetadata.put("sId", (Object)this.prefHelper_.getSessionID());
                statsMetadata.put("status", 200);
            }
            catch (Exception je) {
                DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
            }
            long endTime = System.currentTimeMillis();
            DNAStatsLogger.logInternal((Context)this.context_.get(), "Stats Sync", (int)(endTime - this.startTime), statsMetadata);
        }
        catch (Exception ex) {
            DNALogger.e("DNANetworkRequestStats: " + ex.getMessage());
        }
    }

    @Override
    public void handleFailure(int statusCode, String causeMsg) {
        DNALogger.e("DNANetworkRequestStats: handleFailure: " + statusCode + " : " + causeMsg);
        DNAPreferences prefs = DNAPreferences.getInstance((Context)this.context_.get());
        JSONObject statsMetadata = new JSONObject();
        try {
            statsMetadata.put("sId", (Object)prefs.getSessionID());
            statsMetadata.put("loc", (Object)"DNANetworkRequestStats.handleFailure");
            statsMetadata.put("m", (Object)causeMsg);
        }
        catch (Exception je) {
            DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
        }
        DNAStatsLogger.logInternal((Context)this.context_.get(), "Error", statusCode, statsMetadata);
    }

    @Override
    public boolean isGetRequest() {
        return false;
    }
}

