/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna.network;

import android.os.NetworkOnMainThreadException;
import android.util.Log;
import com.devicenative.dna.network.DNANetworkInterface;
import com.devicenative.dna.utils.DNALogger;
import com.devicenative.dna.utils.DNAPreferences;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class DNANetworkInterfaceHTTPConnection
extends DNANetworkInterface {
    @Override
    public DNANetworkInterface.DNANetworkRawResponse doGet(String url) throws DNANetworkInterface.DNANetworkException {
        return this.doGet(url, 0);
    }

    @Override
    public DNANetworkInterface.DNANetworkRawResponse doPost(String url, JSONObject payload) throws DNANetworkInterface.DNANetworkException {
        return this.doPost(url, payload, 0);
    }

    private DNANetworkInterface.DNANetworkRawResponse doGet(String url, int retryNumber) throws DNANetworkInterface.DNANetworkException {
        DNANetworkInterface.DNANetworkRawResponse e3;
        HttpURLConnection connection = null;
        DNAPreferences prefHelper = DNAPreferences.getInstance();
        try {
            DNANetworkInterface.DNANetworkRawResponse result;
            String appendKey = url.contains("?") ? "&" : "?";
            String modifiedUrl = url + appendKey + "retry" + "=" + retryNumber;
            URL urlObject = new URL(modifiedUrl);
            connection = (HttpsURLConnection)urlObject.openConnection();
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(30000);
            connection.setRequestProperty("Accept-Encoding", "gzip");
            int responseCode = connection.getResponseCode();
            if (responseCode >= 500 && retryNumber < prefHelper.getRetryCount()) {
                try {
                    Thread.sleep(prefHelper.getRetryInterval());
                }
                catch (InterruptedException e2) {
                    DNALogger.e("DNANetworkInterfaceHTTPConnection: Encountered exception while attempting network request: " + Log.getStackTraceString((Throwable)e2));
                }
                DNANetworkInterface.DNANetworkRawResponse e2 = this.doGet(url, ++retryNumber);
                return e2;
            }
            try {
                String encoding = connection.getHeaderField("Content-Encoding");
                result = responseCode != 200 && connection.getErrorStream() != null ? new DNANetworkInterface.DNANetworkRawResponse(this.getResponseString(encoding, connection.getErrorStream()), responseCode) : new DNANetworkInterface.DNANetworkRawResponse(this.getResponseString(encoding, connection.getInputStream()), responseCode);
            }
            catch (FileNotFoundException ex) {
                DNALogger.e("DNANetworkInterfaceHTTPConnection: A resource conflict occurred with this request " + url);
                result = new DNANetworkInterface.DNANetworkRawResponse(null, responseCode);
            }
            DNANetworkInterface.DNANetworkRawResponse dNANetworkRawResponse = result;
            return dNANetworkRawResponse;
        }
        catch (SocketException ex) {
            DNALogger.e("DNANetworkInterfaceHTTPConnection: Http connect exception: " + ex.getMessage());
            throw new DNANetworkInterface.DNANetworkException(-113, ex.getMessage());
        }
        catch (SocketTimeoutException ex) {
            if (retryNumber < prefHelper.getRetryCount()) {
                try {
                    Thread.sleep(prefHelper.getRetryInterval());
                }
                catch (InterruptedException e3) {
                    DNALogger.e("DNANetworkInterfaceHTTPConnection: Encountered exception while attempting network request: " + Log.getStackTraceString((Throwable)e3));
                }
                e3 = this.doGet(url, ++retryNumber);
                return e3;
            }
            throw new DNANetworkInterface.DNANetworkException(-111, ex.getMessage());
        }
        catch (InterruptedIOException ex) {
            if (retryNumber < prefHelper.getRetryCount()) {
                try {
                    Thread.sleep(prefHelper.getRetryInterval());
                }
                catch (InterruptedException e4) {
                    DNALogger.e("DNANetworkInterfaceHTTPConnection: Encountered exception while attempting network request: " + Log.getStackTraceString((Throwable)e4));
                }
                e3 = this.doGet(url, ++retryNumber);
                return e3;
            }
            throw new DNANetworkInterface.DNANetworkException(-120, ex.getMessage());
        }
        catch (IOException ex) {
            DNALogger.e("DNANetworkInterfaceHTTPConnection: Encountered exception while attempting network request: " + Log.getStackTraceString((Throwable)ex));
            if (retryNumber < prefHelper.getRetryCount()) {
                try {
                    Thread.sleep(prefHelper.getRetryInterval());
                }
                catch (InterruptedException e5) {
                    DNALogger.e("DNANetworkInterfaceHTTPConnection: Encountered exception while attempting network request: " + Log.getStackTraceString((Throwable)e5));
                }
                DNANetworkInterface.DNANetworkRawResponse dNANetworkRawResponse = this.doGet(url, ++retryNumber);
                return dNANetworkRawResponse;
            }
            throw new DNANetworkInterface.DNANetworkException(-113, ex.getMessage());
        }
        catch (Exception ex) {
            DNALogger.e("DNANetworkInterfaceHTTPConnection: Encountered exception while attempting network request: " + Log.getStackTraceString((Throwable)ex));
            if (ex instanceof NetworkOnMainThreadException) {
                DNALogger.i("DNANetworkInterfaceHTTPConnection: Cannot make network request on main thread: " + Log.getStackTraceString((Throwable)ex));
                throw new DNANetworkInterface.DNANetworkException(-121, ex.getMessage());
            }
            throw new DNANetworkInterface.DNANetworkException(-122, ex.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private DNANetworkInterface.DNANetworkRawResponse doPost(String url, JSONObject payload, int retryNumber) throws DNANetworkInterface.DNANetworkException {
        DNANetworkInterface.DNANetworkRawResponse e6;
        HttpURLConnection connection = null;
        DNAPreferences prefHelper = DNAPreferences.getInstance();
        try {
            payload.put("retry", retryNumber);
        }
        catch (JSONException e2) {
            DNALogger.e("DNANetworkInterfaceHTTPConnection: " + e2.getMessage());
        }
        try {
            DNANetworkInterface.DNANetworkRawResponse result;
            URL urlObject = new URL(url);
            connection = (HttpsURLConnection)urlObject.openConnection();
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(30000);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("Accept-Encoding", "gzip");
            connection.setRequestProperty("Content-Length", String.valueOf(payload.toString().getBytes().length));
            connection.setRequestMethod("POST");
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(connection.getOutputStream());
            outputStreamWriter.write(payload.toString());
            outputStreamWriter.flush();
            outputStreamWriter.close();
            int responseCode = connection.getResponseCode();
            if (responseCode >= 300 && responseCode < 400) {
                String redirectUrl = connection.getHeaderField("Location");
                if (redirectUrl != null && !redirectUrl.trim().isEmpty()) {
                    if (redirectUrl.startsWith("/")) {
                        try {
                            URL originalUrl = new URL(url);
                            redirectUrl = originalUrl.getProtocol() + "://" + originalUrl.getHost() + (originalUrl.getPort() != -1 ? ":" + originalUrl.getPort() : "") + redirectUrl;
                        }
                        catch (Exception e3) {
                            DNALogger.e("DNANetworkInterfaceHTTPConnection: Error resolving relative redirect URL: " + e3.getMessage());
                            DNANetworkInterface.DNANetworkRawResponse dNANetworkRawResponse = new DNANetworkInterface.DNANetworkRawResponse("Error resolving redirect URL", responseCode);
                            if (connection != null) {
                                connection.disconnect();
                            }
                            return dNANetworkRawResponse;
                        }
                    }
                    DNALogger.i("DNANetworkInterfaceHTTPConnection: POST received " + responseCode + " redirect, following to: " + redirectUrl);
                    connection.disconnect();
                    DNANetworkInterface.DNANetworkRawResponse e3 = this.doGet(redirectUrl, 0);
                    return e3;
                }
                DNALogger.e("DNANetworkInterfaceHTTPConnection: Redirect response " + responseCode + " without valid Location header");
                DNANetworkInterface.DNANetworkRawResponse e3 = new DNANetworkInterface.DNANetworkRawResponse("Redirect without Location header", responseCode);
                return e3;
            }
            if (responseCode >= 500 && retryNumber < prefHelper.getRetryCount()) {
                try {
                    Thread.sleep(prefHelper.getRetryInterval());
                }
                catch (InterruptedException e4) {
                    DNALogger.e("DNANetworkInterfaceHTTPConnection: Encountered exception while attempting network request: " + Log.getStackTraceString((Throwable)e4));
                }
                DNANetworkInterface.DNANetworkRawResponse e4 = this.doPost(url, payload, ++retryNumber);
                return e4;
            }
            try {
                String encoding = connection.getHeaderField("Content-Encoding");
                result = responseCode != 200 && connection.getErrorStream() != null ? new DNANetworkInterface.DNANetworkRawResponse(this.getResponseString(encoding, connection.getErrorStream()), responseCode) : new DNANetworkInterface.DNANetworkRawResponse(this.getResponseString(encoding, connection.getInputStream()), responseCode);
            }
            catch (FileNotFoundException ex) {
                DNALogger.e("DNANetworkInterfaceHTTPConnection: A resource conflict occurred with this request " + url);
                result = new DNANetworkInterface.DNANetworkRawResponse(null, responseCode);
            }
            DNANetworkInterface.DNANetworkRawResponse dNANetworkRawResponse = result;
            return dNANetworkRawResponse;
        }
        catch (SocketTimeoutException ex) {
            DNALogger.i("DNANetworkInterfaceHTTPConnection: Encountered exception while attempting network request: " + Log.getStackTraceString((Throwable)ex));
            if (retryNumber < prefHelper.getRetryCount()) {
                try {
                    Thread.sleep(prefHelper.getRetryInterval());
                }
                catch (InterruptedException e5) {
                    DNALogger.e("DNANetworkInterfaceHTTPConnection: Encountered exception while attempting network request: " + Log.getStackTraceString((Throwable)e5));
                }
                e6 = this.doPost(url, payload, ++retryNumber);
                return e6;
            }
            throw new DNANetworkInterface.DNANetworkException(-111, Log.getStackTraceString((Throwable)ex));
        }
        catch (InterruptedIOException ex) {
            DNALogger.e("DNANetworkInterfaceHTTPConnection: Encountered exception while attempting network request: " + ex);
            if (retryNumber < prefHelper.getRetryCount()) {
                try {
                    Thread.sleep(prefHelper.getRetryInterval());
                }
                catch (InterruptedException e6) {
                    DNALogger.e("DNANetworkInterfaceHTTPConnection: Encountered exception while attempting network request: " + Log.getStackTraceString((Throwable)e6));
                }
                e6 = this.doPost(url, payload, ++retryNumber);
                return e6;
            }
            throw new DNANetworkInterface.DNANetworkException(-120, ex.getMessage());
        }
        catch (IOException ex) {
            DNALogger.e("DNANetworkInterfaceHTTPConnection: Encountered exception while attempting network request: " + Log.getStackTraceString((Throwable)ex));
            if (retryNumber < prefHelper.getRetryCount()) {
                try {
                    Thread.sleep(prefHelper.getRetryInterval());
                }
                catch (InterruptedException e7) {
                    DNALogger.e("DNANetworkInterfaceHTTPConnection: Encountered exception while attempting network request: " + Log.getStackTraceString((Throwable)e7));
                }
                DNANetworkInterface.DNANetworkRawResponse dNANetworkRawResponse = this.doPost(url, payload, ++retryNumber);
                return dNANetworkRawResponse;
            }
            throw new DNANetworkInterface.DNANetworkException(-113, ex.getMessage());
        }
        catch (Exception ex) {
            DNALogger.e("DNANetworkInterfaceHTTPConnection: Encountered exception while attempting network request: " + Log.getStackTraceString((Throwable)ex));
            if (ex instanceof NetworkOnMainThreadException) {
                DNALogger.i("DNANetworkInterfaceHTTPConnection: Cannot make network request on main thread: " + Log.getStackTraceString((Throwable)ex));
                throw new DNANetworkInterface.DNANetworkException(-121, ex.getMessage());
            }
            throw new DNANetworkInterface.DNANetworkException(-122, ex.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private String getResponseString(String encoding, InputStream inputStream) {
        String responseString = null;
        if (inputStream != null) {
            try {
                String line;
                InputStream decodedStream = "gzip".equalsIgnoreCase(encoding) ? new GZIPInputStream(inputStream) : inputStream;
                BufferedReader rd = new BufferedReader(new InputStreamReader(decodedStream));
                StringBuilder sb = new StringBuilder();
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
                rd.close();
                responseString = sb.toString();
            }
            catch (IOException e) {
                DNALogger.e("DNANetworkInterfaceHTTPConnection: " + e.getMessage());
            }
        }
        return responseString;
    }
}

