/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna.network;

import com.devicenative.dna.network.DNANetworkResponse;
import com.devicenative.dna.utils.DNALogger;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class DNANetworkInterface {
    public static final String RETRY_NUMBER = "retry";

    public abstract DNANetworkRawResponse doGet(String var1) throws DNANetworkException;

    public abstract DNANetworkRawResponse doPost(String var1, JSONObject var2) throws DNANetworkException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DNANetworkResponse executeGet(String url, JSONObject params) {
        String modifiedUrl = url;
        params = params != null ? params : new JSONObject();
        modifiedUrl = modifiedUrl + this.convertJSONtoQueryString(params);
        long reqStartTime = System.currentTimeMillis();
        DNALogger.i("GET started to " + modifiedUrl);
        try {
            DNANetworkRawResponse response = this.doGet(modifiedUrl);
            DNANetworkResponse dNANetworkResponse = this.processRawResponseForJSON(response);
            return dNANetworkResponse;
        }
        catch (DNANetworkException dnaError) {
            DNANetworkResponse dNANetworkResponse = new DNANetworkResponse(dnaError.errorCode, dnaError.errorMessage);
            return dNANetworkResponse;
        }
        finally {
            int rttVal = (int)(System.currentTimeMillis() - reqStartTime);
            DNALogger.i("GET completed in " + rttVal + "ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DNANetworkResponse executePost(JSONObject body, String url) {
        long reqStartTime = System.currentTimeMillis();
        body = body != null ? body : new JSONObject();
        DNALogger.i("POST started to " + url);
        DNALogger.i("Post value = " + body.toString());
        try {
            DNANetworkRawResponse response = this.doPost(url, body);
            DNANetworkResponse dNANetworkResponse = this.processRawResponseForJSON(response);
            return dNANetworkResponse;
        }
        catch (DNANetworkException dnaError) {
            DNANetworkResponse dNANetworkResponse = new DNANetworkResponse(dnaError.errorCode, dnaError.errorMessage);
            return dNANetworkResponse;
        }
        finally {
            int rttVal = (int)(System.currentTimeMillis() - reqStartTime);
            DNALogger.i("DNANetworkInterface: POST completed in " + rttVal + "ms");
        }
    }

    private DNANetworkResponse processRawResponseForJSON(DNANetworkRawResponse response) {
        String responseString = response.responseData;
        int statusCode = response.responseCode;
        DNANetworkResponse result = new DNANetworkResponse(statusCode, "");
        DNALogger.i(String.format(Locale.getDefault(), "DNANetworkInterface: Server returned: status: [%d]; Data: %s", statusCode, responseString));
        if (responseString != null && !responseString.isEmpty()) {
            try {
                JSONObject jsonObj = new JSONObject(responseString);
                result.setBody(jsonObj);
            }
            catch (JSONException ex) {
                try {
                    JSONArray jsonArray = new JSONArray(responseString);
                    result.setBody(jsonArray);
                }
                catch (JSONException ex2) {
                    DNALogger.e("DNANetworkInterface: JSON exception: " + ex2.getMessage());
                }
            }
        }
        return result;
    }

    private String convertJSONtoQueryString(JSONObject json) {
        JSONArray names;
        StringBuilder result = new StringBuilder();
        if (json != null && (names = json.names()) != null) {
            boolean first = true;
            int size = names.length();
            for (int i = 0; i < size; ++i) {
                try {
                    String key = names.getString(i);
                    if (first) {
                        result.append("?");
                        first = false;
                    } else {
                        result.append("&");
                    }
                    String value = json.getString(key);
                    result.append(key).append("=").append(value);
                    continue;
                }
                catch (JSONException e) {
                    DNALogger.e("DNANetworkInterface: JSON exception: " + e.getMessage());
                    return null;
                }
            }
        }
        return result.toString();
    }

    public static class DNANetworkRawResponse {
        private final String responseData;
        private final int responseCode;

        public DNANetworkRawResponse(String responseData, int responseCode) {
            this.responseData = responseData;
            this.responseCode = responseCode;
        }
    }

    public static class DNANetworkException
    extends Exception {
        private final int errorCode;
        private String errorMessage;

        public DNANetworkException(int errorCode) {
            this.errorCode = errorCode;
        }

        public DNANetworkException(int errorCode, String errorMessage) {
            this.errorCode = errorCode;
            this.errorMessage = errorMessage;
        }
    }
}

