/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna.datasource.loader;

import android.content.Context;
import com.devicenative.dna.datasource.loader.DNALoader;
import com.devicenative.dna.network.DNANetworkInterfaceHTTPConnection;
import com.devicenative.dna.network.DNANetworkRequest;
import com.devicenative.dna.network.DNANetworkResponse;
import com.devicenative.dna.utils.DNALogger;
import org.json.JSONObject;

public class DNAServerPOSTLoader
extends DNALoader {
    private final DNANetworkRequest request_;

    public DNAServerPOSTLoader(Context context, DNANetworkRequest request) {
        super(context);
        this.request_ = request;
    }

    @Override
    public void run() {
        long start;
        block5: {
            start = System.currentTimeMillis();
            this.request_.onPreExecute();
            DNANetworkInterfaceHTTPConnection httpConn = new DNANetworkInterfaceHTTPConnection();
            DNANetworkResponse response = httpConn.executePost(this.request_.getPost(), this.request_.getRequestUrl());
            if (response.getStatusCode() == 200) {
                try {
                    JSONObject body = response.getBody();
                    if (body.has("success") && !body.getBoolean("success")) {
                        this.request_.handleFailure(-116, body.getString("message"));
                        break block5;
                    }
                    this.request_.onRequestSucceeded(response);
                }
                catch (Exception e) {
                    DNALogger.e("DNAServerPOSTLoader: " + e.getMessage());
                    this.request_.handleFailure(-116, "No success or message fields in response. Something went wrong on the server.");
                }
            } else {
                this.request_.handleFailure(response.getStatusCode(), response.getMessage());
            }
        }
        long end = System.currentTimeMillis();
        DNALogger.i("DNAServerPOSTLoader: " + (end - start) + " milliseconds to complete network request");
        this.runnableFinished();
    }
}

