/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna.datasource.loader;

import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.LauncherActivityInfo;
import android.content.pm.LauncherApps;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.UserHandle;
import android.os.UserManager;
import com.devicenative.dna.datasource.loader.DNALoader;
import com.devicenative.dna.db.DNAAppRecord;
import com.devicenative.dna.db.DNADatabaseInterface;
import com.devicenative.dna.db.DNADatabaseQueue;
import com.devicenative.dna.utils.DNALogger;
import com.devicenative.dna.utils.DNAPreferences;
import com.devicenative.dna.utils.DNAUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DNAAppLoader
extends DNALoader {
    public DNAAppLoader(Context context) {
        super(context);
    }

    @Override
    public void run() {
        DNADatabaseQueue.enqueue((Context)this.context.get(), () -> this.loadAllApps());
    }

    private void loadAllApps() {
        ArrayList<DNAAppRecord> apps = new ArrayList<DNAAppRecord>();
        Context ctx = (Context)this.context.get();
        DNAPreferences prefs = DNAPreferences.getInstance(ctx);
        UserManager manager = (UserManager)ctx.getSystemService("user");
        LauncherApps launcher = (LauncherApps)ctx.getSystemService("launcherapps");
        PackageManager pManager = ctx.getPackageManager();
        Map<String, String> tagsMap = this.getTagsMap(pManager);
        UsageStatsManager usageStatsManager = (UsageStatsManager)ctx.getSystemService("usagestats");
        boolean isUsageStatsEnabled = false;
        Calendar cal = Calendar.getInstance();
        cal.add(1, -2);
        Map statsMap = new HashMap();
        try {
            statsMap = usageStatsManager.queryAndAggregateUsageStats(cal.getTimeInMillis(), System.currentTimeMillis());
        }
        catch (RuntimeException e) {
            DNALogger.e("DNAAppLoader: queryAndAggregateUsageStats failed: " + e.getMessage());
        }
        for (UserHandle profile : manager.getUserProfiles()) {
            List launcherActivities;
            if (!manager.isUserRunning(profile) || !manager.isUserUnlocked(profile)) continue;
            boolean isUserInQuietMode = manager.isQuietModeEnabled(profile);
            try {
                launcherActivities = launcher.getActivityList(null, profile);
            }
            catch (RuntimeException e) {
                DNALogger.e("DNAAppLoader: getActivityList failed for " + profile + ": " + e.getMessage());
                continue;
            }
            for (LauncherActivityInfo activityInfo : launcherActivities) {
                if (activityInfo == null) continue;
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                ApplicationInfo appInfo = activityInfo.getApplicationInfo();
                if (!launcher.isPackageEnabled(appInfo.packageName, profile) || !launcher.isActivityEnabled(activityInfo.getComponentName(), profile)) continue;
                if (Build.VERSION.SDK_INT >= 29) {
                    if (launcher.shouldHideFromSuggestions(appInfo.packageName, profile)) {
                        prefs.setPackageHidden(appInfo.packageName, profile.toString(), true);
                    } else if (prefs.isPackageHidden(appInfo.packageName, profile.toString())) {
                        prefs.setPackageHidden(appInfo.packageName, profile.toString(), false);
                    }
                }
                if (DNAUtils.isArchived(appInfo) || DNAUtils.isSuspended(appInfo) || isUserInQuietMode) {
                    prefs.setPackageHidden(appInfo.packageName, profile.toString(), true);
                } else if (prefs.isPackageHidden(appInfo.packageName, profile.toString())) {
                    prefs.setPackageHidden(appInfo.packageName, profile.toString(), false);
                }
                DNAAppRecord app = new DNAAppRecord();
                app.packageName = appInfo.packageName;
                app.userId = profile.toString();
                app.name = activityInfo.getLabel() != null ? String.valueOf(activityInfo.getLabel()) : appInfo.loadLabel(pManager).toString();
                app.component = activityInfo.getName();
                app.installedAt = activityInfo.getFirstInstallTime();
                app.updatedAt = System.currentTimeMillis();
                if (tagsMap.containsKey(app.packageName)) {
                    app.aliases = tagsMap.get(app.packageName);
                }
                if (statsMap.containsKey(app.packageName)) {
                    isUsageStatsEnabled = true;
                    app.lastUsedAt = Objects.requireNonNull((UsageStats)statsMap.get(app.packageName)).getLastTimeUsed();
                    app.timeUsedInLast3Y = Objects.requireNonNull((UsageStats)statsMap.get(app.packageName)).getTotalTimeInForeground() / 1000L;
                }
                apps.add(app);
            }
        }
        if (isUsageStatsEnabled) {
            prefs.setFirstUsageRead(true);
        }
        List<DNAAppRecord> existingApps = DNADatabaseInterface.getAllAppRecords(ctx);
        ArrayList<DNAAppRecord> appsToInsertOrUpdate = new ArrayList<DNAAppRecord>();
        for (DNAAppRecord app : apps) {
            boolean found = false;
            for (DNAAppRecord existingApp : existingApps) {
                if (!existingApp.packageName.equals(app.packageName) || !existingApp.userId.equals(app.userId) || existingApp.uninstalledAt != 0L || existingApp.component != null && !Objects.equals(existingApp.component, app.component) || !Objects.equals(existingApp.name, app.name) || !Objects.equals(existingApp.aliases, app.aliases)) continue;
                found = true;
                break;
            }
            if (found) continue;
            appsToInsertOrUpdate.add(app);
        }
        for (DNAAppRecord existingApp : existingApps) {
            boolean found = false;
            for (DNAAppRecord app : apps) {
                if (!existingApp.packageName.equals(app.packageName) || !Objects.equals(existingApp.userId, app.userId)) continue;
                found = true;
                break;
            }
            if (!(!found & existingApp.uninstalledAt == 0L)) continue;
            existingApp.uninstalledAt = System.currentTimeMillis();
            appsToInsertOrUpdate.add(existingApp);
        }
        DNADatabaseInterface.insertOrUpdateAppRecords(ctx, appsToInsertOrUpdate);
        apps.clear();
        appsToInsertOrUpdate.clear();
        existingApps.clear();
        this.runnableFinished();
    }

    private Map<String, String> getTagsMap(PackageManager pManager) {
        HashMap<String, String> tagsMap = new HashMap<String, String>();
        this.mapAppsToTags(tagsMap, pManager, new Intent("android.intent.action.DIAL"), "dial,call,phone");
        this.mapAppsToTags(tagsMap, pManager, this.getCategoryIntent("android.intent.category.APP_CONTACTS"), "contacts,people,friends");
        this.mapAppsToTags(tagsMap, pManager, this.getCategoryIntent("android.intent.category.APP_BROWSER"), "web,browser,internet");
        this.mapAppsToTags(tagsMap, pManager, this.getCategoryIntent("android.intent.category.APP_EMAIL"), "mail,email,e-mail");
        this.mapAppsToTags(tagsMap, pManager, this.getCategoryIntent("android.intent.category.APP_MARKET"), "market,store,play,apps,appstore,app store,app center");
        this.mapAppsToTags(tagsMap, pManager, this.getCategoryIntent("android.intent.category.APP_MESSAGING"), "text,message,compose,sms,mms,messaging");
        this.mapAppsToTags(tagsMap, pManager, new Intent("android.intent.action.SHOW_ALARMS"), "clock,alarm,timer,stopwatch");
        this.mapAppsToTags(tagsMap, pManager, this.getCategoryIntent("android.intent.category.APP_MAPS"), "map,maps,navigate,directions");
        this.mapAppsToTags(tagsMap, pManager, new Intent("android.intent.action.CAMERA_BUTTON"), "camera,photo,picture");
        this.mapAppsToTags(tagsMap, pManager, this.getCategoryIntent("android.intent.category.APP_MUSIC"), "music,song,play,listen");
        this.mapAppsToTags(tagsMap, pManager, this.getCategoryIntent("android.intent.category.APP_CALENDAR"), "calendar,agenda,schedule");
        this.mapAppsToTags(tagsMap, pManager, this.getCategoryIntent("android.intent.category.APP_GALLERY"), "gallery,photos,pictures");
        this.mapAppsToTags(tagsMap, pManager, this.getCategoryIntent("android.intent.category.APP_FILES"), "file,files,manager,explorer");
        return tagsMap;
    }

    private Intent getCategoryIntent(String category) {
        Intent intent = new Intent("android.intent.action.MAIN", null);
        intent.addCategory(category);
        return intent;
    }

    private void mapAppsToTags(Map<String, String> tagsMap, PackageManager pManager, Intent intentFilter, String alias) {
        List<String> apps = this.getAppsByCategory(pManager, intentFilter);
        for (String app : apps) {
            tagsMap.merge(app, alias, (oldValue, newValue) -> oldValue.contains((CharSequence)newValue) ? oldValue : oldValue + "," + newValue);
        }
    }

    private List<String> getAppsByCategory(PackageManager pManager, Intent intent) {
        List list = pManager.queryIntentActivities(intent, 0);
        ArrayList<String> apps = new ArrayList<String>(list.size());
        for (ResolveInfo resolveInfo : list) {
            String pName = resolveInfo.activityInfo.applicationInfo.packageName;
            apps.add(pName);
        }
        return apps;
    }
}

