/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna.broadcast;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.UserHandle;
import com.devicenative.dna.ads.DNAAppSearchFallback;
import com.devicenative.dna.broadcast.DNAPackageChangedReceiver;
import com.devicenative.dna.db.DNADatabaseInterface;
import com.devicenative.dna.utils.DNALogger;
import com.devicenative.dna.utils.DNAPreferences;

public class DNAProfileChangeReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if ("android.intent.action.MANAGED_PROFILE_ADDED".equals(action) || "android.intent.action.MANAGED_PROFILE_REMOVED".equals(action) || "android.intent.action.MANAGED_PROFILE_AVAILABLE".equals(action) || "android.intent.action.MANAGED_PROFILE_UNAVAILABLE".equals(action) || "android.intent.action.USER_UNLOCKED".equals(action)) {
            UserHandle user;
            DNALogger.i("DNAProfileChangeReceiver: " + action + " at " + System.currentTimeMillis());
            if (action.contains("MANAGED_PROFILE") && (user = (UserHandle)intent.getParcelableExtra("android.intent.extra.USER")) != null) {
                DNALogger.i("DNAProfileChangeReceiver: User handle: " + user.toString());
            }
            DNADatabaseInterface.removeAllShortcuts(context);
            DNAPreferences prefs = DNAPreferences.getInstance(context);
            prefs.setAppsNeedReload();
            DNAPackageChangedReceiver.triggerImmediateReload(context);
            DNAAppSearchFallback.clearCache();
        }
    }

    public void register(Context context) {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.MANAGED_PROFILE_ADDED");
        filter.addAction("android.intent.action.MANAGED_PROFILE_REMOVED");
        filter.addAction("android.intent.action.MANAGED_PROFILE_AVAILABLE");
        filter.addAction("android.intent.action.MANAGED_PROFILE_UNAVAILABLE");
        filter.addAction("android.intent.action.USER_UNLOCKED");
        context.registerReceiver((BroadcastReceiver)this, filter);
    }
}

