/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna.ads;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.LauncherActivityInfo;
import android.content.pm.LauncherApps;
import android.os.Process;
import android.os.UserHandle;
import com.devicenative.dna.DNAResultItem;
import com.devicenative.dna.utils.DNALogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONObject;

public class DNAAppSearchFallback {
    private static final Object CACHE_LOCK = new Object();
    private static List<DNAResultItem> cachedAppResults = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Object object = CACHE_LOCK;
        synchronized (object) {
            if (cachedAppResults != null) {
                cachedAppResults.clear();
            }
            cachedAppResults = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DNAResultItem> getAppResultsForDisplayFallback(Context context, int count) {
        String packageName;
        if (cachedAppResults == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (cachedAppResults == null) {
                    cachedAppResults = DNAAppSearchFallback.loadInstalledApps(context);
                }
            }
        }
        List<String> defaultPackages = Arrays.asList("com.android.vending", "com.android.chrome", "com.android.dialer", "com.android.camera", "com.android.settings", "com.google.android.apps.maps", "com.google.android.youtube");
        ArrayList<DNAResultItem> defaultApps = new ArrayList<DNAResultItem>();
        for (DNAResultItem app : cachedAppResults) {
            packageName = app.packageName;
            if (!defaultPackages.contains(packageName)) continue;
            defaultApps.add(app);
        }
        if (defaultApps.size() > count) {
            return defaultApps.subList(0, count);
        }
        if (defaultApps.size() < count) {
            for (DNAResultItem app : cachedAppResults) {
                if (defaultApps.size() >= count) break;
                packageName = app.packageName;
                if (defaultPackages.contains(packageName)) continue;
                defaultApps.add(app);
            }
        }
        return defaultApps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DNAResultItem> getAppResultsForSearchFallback(Context context, String query) {
        if (query == null || query.length() == 0) {
            return new ArrayList<DNAResultItem>();
        }
        if (cachedAppResults == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (cachedAppResults == null) {
                    cachedAppResults = DNAAppSearchFallback.loadInstalledApps(context);
                }
            }
        }
        List<String> queryParts = DNAAppSearchFallback.processQueryIntoParts(query);
        ArrayList<DNAResultItem> startPrefixMatchedApps = new ArrayList<DNAResultItem>();
        ArrayList<DNAResultItem> laterPrefixMatchedApps = new ArrayList<DNAResultItem>();
        ArrayList<DNAResultItem> containsMatchedApps = new ArrayList<DNAResultItem>();
        block3: for (DNAResultItem item : cachedAppResults) {
            String appName = item.appName;
            List<String> appNameParts = DNAAppSearchFallback.processAppNameIntoParts(appName);
            boolean matched = false;
            block4: for (int j = 0; j < appNameParts.size() && !matched; ++j) {
                String part = appNameParts.get(j);
                for (String queryPart : queryParts) {
                    if (!part.startsWith(queryPart)) continue;
                    if (j == 0) {
                        startPrefixMatchedApps.add(item);
                    } else {
                        laterPrefixMatchedApps.add(item);
                    }
                    matched = true;
                    continue block4;
                }
            }
            if (matched || query.length() <= 2) continue;
            for (String part : appNameParts) {
                for (String queryPart : queryParts) {
                    if (!part.contains(queryPart)) continue;
                    containsMatchedApps.add(item);
                    matched = true;
                    break;
                }
                if (!matched) continue;
                continue block3;
            }
        }
        ArrayList<DNAResultItem> filteredResults = new ArrayList<DNAResultItem>();
        filteredResults.addAll(startPrefixMatchedApps);
        filteredResults.addAll(laterPrefixMatchedApps);
        filteredResults.addAll(containsMatchedApps);
        return filteredResults;
    }

    private static List<DNAResultItem> loadInstalledApps(Context context) {
        ArrayList<DNAResultItem> appResults = new ArrayList<DNAResultItem>();
        UserHandle currentUser = Process.myUserHandle();
        LauncherApps launcher = (LauncherApps)context.getSystemService("launcherapps");
        if (launcher == null) {
            return appResults;
        }
        for (LauncherActivityInfo activityInfo : launcher.getActivityList(null, currentUser)) {
            if (activityInfo == null) continue;
            ApplicationInfo appInfo = activityInfo.getApplicationInfo();
            JSONObject appData = new JSONObject();
            try {
                appData.put("id", (Object)(appInfo.packageName + "-" + currentUser.toString()));
                appData.put("packageName", (Object)appInfo.packageName);
                if (activityInfo.getLabel() != null) {
                    appData.put("appName", (Object)String.valueOf(activityInfo.getLabel()));
                } else {
                    appData.put("appName", (Object)appInfo.loadLabel(context.getPackageManager()).toString());
                }
                appData.put("component", (Object)activityInfo.getName());
                appData.put("userId", (Object)currentUser.toString());
            }
            catch (Exception e) {
                DNALogger.e("Error while creating app data: " + e.getMessage());
            }
            DNAResultItem app = new DNAResultItem(appData, "app");
            app.updateAppInstalledState(context);
            appResults.add(app);
        }
        return appResults;
    }

    private static List<String> processQueryIntoParts(String query) {
        String[] parts;
        ArrayList<String> queryParts = new ArrayList<String>();
        for (String part : parts = query.split(" ")) {
            if ((part = part.trim()).length() <= 0) continue;
            queryParts.add(part.toLowerCase());
        }
        String[] dotParts = query.split("\\.");
        if (dotParts.length > 1) {
            for (String part : dotParts) {
                if ((part = part.trim()).length() <= 0) continue;
                queryParts.add(part.toLowerCase());
            }
        }
        return queryParts;
    }

    private static List<String> processAppNameIntoParts(String appName) {
        String[] splitParts;
        ArrayList<String> parts = new ArrayList<String>();
        String lowerAppName = appName.toLowerCase();
        parts.add(lowerAppName);
        for (String part : splitParts = appName.split("[ \\u00A0]+")) {
            String lowerPart = part.toLowerCase();
            if (parts.contains(lowerPart) || lowerPart.length() <= 0) continue;
            String[] capParts = part.split("(?<=[a-z])(?=[A-Z])");
            if (capParts.length > 1) {
                for (String capPart : capParts) {
                    String capLower;
                    if (capPart.length() <= 0 || parts.contains(capLower = capPart.toLowerCase())) continue;
                    parts.add(capLower);
                }
            }
            parts.add(lowerPart);
        }
        return parts;
    }
}

