/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.LauncherActivityInfo;
import android.content.pm.LauncherApps;
import android.content.pm.ShortcutInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.os.UserHandle;
import com.devicenative.dna.utils.DNALogger;
import com.devicenative.dna.utils.DNAUtils;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONObject;

public class DNAResultItem
implements Parcelable {
    public static final String TYPE_APP = "app";
    public static final String TYPE_AD = "ad";
    public static final String TYPE_SHORTCUT = "shortcut";
    public static final String TYPE_NOTIFICATION = "notification";
    public static final String TYPE_CONTACT = "contact";
    public static final String TYPE_SEARCH = "search";
    public String id;
    public String packageName;
    public String className;
    public String userHandle;
    public int uId;
    public boolean isInstalled;
    public String resultType;
    public String appName;
    public String title;
    public String description;
    public String iconUrl;
    public String clickUrl;
    public String destinationUrl;
    public int ratings;
    public double rating;
    public int downloads;
    public String category;
    public String impressionUrl;
    public int viewThrough;
    public boolean notPlayStore;
    public String source;
    public String placementTag;
    public DNAResultItem parentResultItem;
    public transient JSONObject statMetadata;
    public static final Parcelable.Creator<DNAResultItem> CREATOR = new Parcelable.Creator<DNAResultItem>(){

        public DNAResultItem createFromParcel(Parcel in) {
            return new DNAResultItem(in);
        }

        public DNAResultItem[] newArray(int size) {
            return new DNAResultItem[size];
        }
    };

    public DNAResultItem(JSONObject rawItem, String type) {
        switch (type) {
            case "ad": {
                this.id = rawItem.optString("id");
                this.packageName = rawItem.optString("packageName");
                this.userHandle = rawItem.optString("userId");
                this.uId = DNAUtils.readPidFromUserHandleString(this.userHandle);
                this.appName = rawItem.optString("appName");
                this.title = rawItem.optString("title");
                this.description = rawItem.optString("description");
                this.iconUrl = rawItem.optString("iconUrl");
                this.clickUrl = rawItem.optString("clickUrl");
                this.destinationUrl = rawItem.optString("destinationUrl");
                this.impressionUrl = rawItem.optString("impressionUrl");
                this.viewThrough = rawItem.optInt("viewThrough");
                this.notPlayStore = rawItem.optBoolean("notPlayStore");
                this.ratings = rawItem.optInt("ratings");
                this.downloads = rawItem.optInt("downloads");
                this.rating = rawItem.optDouble("rating");
                this.category = rawItem.optString("category");
                break;
            }
            case "app": {
                this.id = rawItem.optString("id");
                this.packageName = rawItem.optString("packageName");
                this.appName = rawItem.optString("appName");
                this.className = rawItem.optString("component");
                this.userHandle = rawItem.optString("userId");
                this.uId = DNAUtils.readPidFromUserHandleString(this.userHandle);
                this.title = rawItem.optString("appName");
                break;
            }
            case "shortcut": {
                this.id = rawItem.optString("id");
                this.packageName = rawItem.optString("packageName");
                this.appName = rawItem.optString("appName");
                this.title = rawItem.optString("title");
                this.description = rawItem.optString("description");
                this.clickUrl = rawItem.optString("intentUri");
                break;
            }
            case "notification": {
                this.id = rawItem.optString("id");
                this.packageName = rawItem.optString("packageName");
                this.appName = rawItem.optString("appName");
                this.title = rawItem.optString("title");
                this.description = rawItem.optString("description");
            }
        }
        this.resultType = type;
    }

    protected DNAResultItem(Parcel in) {
        this.id = in.readString();
        this.packageName = in.readString();
        this.userHandle = in.readString();
        this.uId = in.readInt();
        this.className = in.readString();
        this.isInstalled = in.readByte() != 0;
        this.resultType = in.readString();
        this.appName = in.readString();
        this.title = in.readString();
        this.description = in.readString();
        this.iconUrl = in.readString();
        this.clickUrl = in.readString();
        this.destinationUrl = in.readString();
        this.ratings = in.readInt();
        this.rating = in.readDouble();
        this.downloads = in.readInt();
        this.category = in.readString();
        this.impressionUrl = in.readString();
        this.viewThrough = in.readInt();
        this.notPlayStore = in.readByte() != 0;
        this.source = in.readString();
        this.placementTag = in.readString();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.packageName);
        dest.writeString(this.userHandle);
        dest.writeInt(this.uId);
        dest.writeString(this.className);
        dest.writeByte((byte)(this.isInstalled ? 1 : 0));
        dest.writeString(this.resultType);
        dest.writeString(this.appName);
        dest.writeString(this.title);
        dest.writeString(this.description);
        dest.writeString(this.iconUrl);
        dest.writeString(this.clickUrl);
        dest.writeString(this.destinationUrl);
        dest.writeInt(this.ratings);
        dest.writeDouble(this.rating);
        dest.writeInt(this.downloads);
        dest.writeString(this.category);
        dest.writeString(this.impressionUrl);
        dest.writeInt(this.viewThrough);
        dest.writeByte((byte)(this.notPlayStore ? 1 : 0));
        dest.writeString(this.source);
        dest.writeString(this.placementTag);
    }

    public int describeContents() {
        return 0;
    }

    public void setParentResultItem(DNAResultItem parentResultItem) {
        this.parentResultItem = parentResultItem;
    }

    public void updateAppInstalledState(Context context) {
        UserHandle profile;
        LauncherApps la = (LauncherApps)context.getSystemService(LauncherApps.class);
        if (la == null) {
            this.isInstalled = false;
            return;
        }
        if (this.userHandle != null && !this.userHandle.isEmpty()) {
            profile = DNAUtils.getUserHandleFromFormattedString(this.userHandle);
        } else {
            profile = Process.myUserHandle();
            this.userHandle = profile.toString();
            this.uId = DNAUtils.readPidFromUserHandleString(this.userHandle);
        }
        if (!la.isPackageEnabled(this.packageName, profile)) {
            this.isInstalled = false;
            return;
        }
        List acts = la.getActivityList(this.packageName, profile);
        if (this.className != null && !this.className.isEmpty()) {
            for (LauncherActivityInfo act : acts) {
                if (!la.isActivityEnabled(act.getComponentName(), profile) || !this.className.equals(act.getName())) continue;
                this.isInstalled = true;
                return;
            }
            this.isInstalled = false;
        } else if (!acts.isEmpty()) {
            for (LauncherActivityInfo act : acts) {
                if (!la.isActivityEnabled(act.getComponentName(), profile)) continue;
                this.isInstalled = true;
                this.className = act.getName();
                return;
            }
        } else {
            this.isInstalled = false;
        }
    }

    public String toString() {
        return "DNAResultItem: " + this.id + ", " + this.resultType + ", " + this.packageName + ", " + this.appName + ", " + this.title + ", " + this.description;
    }

    public ComponentName getComponentName() {
        if (this.packageName == null || this.className == null) {
            return null;
        }
        return new ComponentName(this.packageName, this.className);
    }

    public void loadCreativeDrawableAsync(Context context, final ImageCallback callback) {
        if (this.resultType.equals(TYPE_SHORTCUT)) {
            Drawable drawable = this.getShortcutDrawable(context);
            if (drawable != null) {
                callback.onImageLoaded(drawable);
            } else {
                callback.onError("No icon for this shortcut.");
            }
            return;
        }
        if (this.iconUrl == null || this.iconUrl.isEmpty()) {
            callback.onError("No icon URL for this ad unit.");
            return;
        }
        final ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Drawable drawable = DNAResultItem.this.getDrawableFromURL(DNAResultItem.this.iconUrl);
                    callback.onImageLoaded(drawable);
                }
                catch (Exception e) {
                    callback.onError(e.getMessage());
                }
                finally {
                    executor.shutdown();
                }
            }
        });
    }

    public Drawable loadCreativeDrawable(Context context) {
        if (this.resultType.equals(TYPE_SHORTCUT)) {
            return this.getShortcutDrawable(context);
        }
        if (this.iconUrl == null || this.iconUrl.isEmpty()) {
            return null;
        }
        return this.getDrawableFromURL(this.iconUrl);
    }

    private Drawable getDrawableFromURL(String src) {
        try {
            URL url = new URL(src);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.connect();
            InputStream input = connection.getInputStream();
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)input);
            return new BitmapDrawable(Resources.getSystem(), bitmap);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Drawable getShortcutDrawable(Context context) {
        try {
            LauncherApps launcherApps = (LauncherApps)context.getSystemService("launcherapps");
            if (Build.VERSION.SDK_INT >= 25) {
                if (launcherApps == null || !launcherApps.hasShortcutHostPermission()) {
                    return null;
                }
                LauncherApps.ShortcutQuery query = new LauncherApps.ShortcutQuery();
                query.setPackage(this.packageName);
                query.setShortcutIds(Collections.singletonList(this.clickUrl));
                query.setQueryFlags(11);
                List shortcuts = launcherApps.getShortcuts(query, Process.myUserHandle());
                if (shortcuts != null) {
                    for (ShortcutInfo shortcut : shortcuts) {
                        if (!shortcut.isEnabled()) continue;
                        return launcherApps.getShortcutIconDrawable(shortcut, 0);
                    }
                }
            }
        }
        catch (Exception e) {
            DNALogger.i("Error loading shortcut icon: " + e.getMessage());
        }
        return null;
    }

    public static interface ImageCallback {
        public void onImageLoaded(Drawable var1);

        public void onError(String var1);
    }
}

