/*
 * Decompiled with CFR 0.152.
 */
package com.shiqi.quickjs;

import com.shiqi.quickjs.JSArray;
import com.shiqi.quickjs.JSContext;
import com.shiqi.quickjs.JSValue;
import com.shiqi.quickjs.JavaTypes;
import com.shiqi.quickjs.TypeAdapter;
import java.lang.reflect.Array;
import java.lang.reflect.Type;

class ArrayTypeAdapter
extends TypeAdapter<Object> {
    public static final TypeAdapter.Factory FACTORY = (depot, type) -> {
        Type elementType = JavaTypes.arrayComponentType(type);
        if (elementType == null) {
            return null;
        }
        Class<?> elementClass = JavaTypes.getRawType(elementType);
        TypeAdapter<Object> elementAdapter = depot.getAdapter(elementType);
        return new ArrayTypeAdapter(elementClass, elementAdapter).nullable();
    };
    private final Class<?> elementClass;
    private final TypeAdapter<Object> elementAdapter;

    private ArrayTypeAdapter(Class<?> elementClass, TypeAdapter<Object> elementAdapter) {
        this.elementClass = elementClass;
        this.elementAdapter = elementAdapter;
    }

    @Override
    public JSValue toJSValue(JSContext context, Object value) {
        JSArray result = context.createJSArray();
        int length = Array.getLength(value);
        for (int i = 0; i < length; ++i) {
            result.setProperty(i, this.elementAdapter.toJSValue(context, Array.get(value, i)));
        }
        return result;
    }

    @Override
    public Object fromJSValue(JSContext context, JSValue value) {
        JSArray array = value.cast(JSArray.class);
        int length = array.getLength();
        Object result = Array.newInstance(this.elementClass, length);
        for (int i = 0; i < length; ++i) {
            Array.set(result, i, this.elementAdapter.fromJSValue(context, array.getProperty(i)));
        }
        return result;
    }
}

