package com.devicenative.dna.utils;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DNAWakeScheduleReceiver extends BroadcastReceiver {
    public interface Listener { void onBroadcastReceived(Intent intent); }

    private final Listener listener;

    public DNAWakeScheduleReceiver(Listener listener) { this.listener = listener; }

    @Override public void onReceive(Context context, Intent intent) {
        final PendingResult pr = goAsync();
        final ExecutorService es = Executors.newSingleThreadExecutor();
        es.execute(() -> {
            try { listener.onBroadcastReceived(intent); }
            finally { pr.finish(); es.shutdown(); }
        });
    }
}
