package com.devicenative.dna.utils;

import android.content.Context;

import com.devicenative.dna.db.DNADatabaseInterface;

import org.json.JSONObject;

import java.util.List;

public class DNAStatsLogger {

    private static String convertJsonToString(JSONObject jsonObject) {
        return jsonObject.toString();
    }

    public static void logInternal(Context context, String event, Integer value, JSONObject metadata) {
        new Thread(() -> {
            logInternalSync(context, event, value, metadata);
        }).start();
    }

    public static void logInternalSync(Context context, String event, Integer value, JSONObject metadata) {
        if (value == null) {
            value = -1;
        }
        DNALogger.i("DNAStatsLogger: logInternalSync: " + event);
        DNAPreferences dnaPreferences = DNAPreferences.getInstance(context);

        DNADatabaseInterface.insertStatRecord(context, event, value, convertJsonToString(metadata), dnaPreferences.getAppPackageName());
    }

    public static void logBatchInternal(Context context, List<StatItem> statItems) {
        new Thread(() -> {
            logBatchInternalSync(context, statItems);
        }).start();
    }

    public static void logBatchInternalSync(Context context, List<StatItem> statItems) {
        DNALogger.i("DNAStatsLogger: logBatchInternalSync: " + statItems.size());
        DNAPreferences dnaPreferences = DNAPreferences.getInstance(context);

        for (StatItem statItem : statItems) {
            DNADatabaseInterface.insertStatRecord(context, statItem.event, statItem.value, convertJsonToString(statItem.metadata), dnaPreferences.getAppPackageName());
        }
    }

    public static class StatItem {
        final String event;
        final Integer value;
        final JSONObject metadata;

        public StatItem(String event, Integer value, JSONObject metadata) {
            this.event = event;
            if (value == null) {
                this.value = -1;
            } else {
                this.value = value;
            }
            this.metadata = metadata;
        }
    }
}
