package com.devicenative.dna.utils;

public class DNAConstants {
    public static final String DNA_SDK_VERSION = "moto-v1.4.12";
    public static final String SOURCE_SUGGESTED_APPS = "suggested apps";
    public static final String SOURCE_SUGGESTED_LINKS = "suggested links";
    public static final String SOURCE_HOT_APPS = "hot apps";
    public static final String SOURCE_SEARCH = "search";


    public static class IntentAlias {
        public static final String PHONE_ALIAS = "dial,call,phone";
        public static final String MESSAGING_ALIAS = "text,message,compose,sms,mms,messaging";
        public static final String EMAIL_ALIAS = "mail,email,e-mail";
        public static final String BROWSER_ALIAS = "web,browser,internet";
        public static final String MARKET_ALIAS = "market,store,play,apps,appstore,app store,app center";
        public static final String CLOCK_ALIAS = "clock,alarm,timer,stopwatch";
        public static final String CONTACTS_ALIAS = "contacts,people,friends";
        public static final String MAPS_ALIAS = "map,maps,navigate,directions";
        public static final String CAMERA_ALIAS = "camera,photo,picture";
        public static final String MUSIC_ALIAS = "music,song,play,listen";
        public static final String CALENDAR_ALIAS = "calendar,agenda,schedule";
        public static final String CALCULATOR_ALIAS = "calculator,compute,math";
        public static final String GALLERY_ALIAS = "gallery,photos,pictures";
        public static final String FILE_MANAGER_ALIAS = "file,files,manager,explorer";
        public static final String SEARCH_ALIAS = "search,find,google";
    }

    public static class RequestParams {
        public static final String ADS_VERSION_KEY = "aVK";
        public static final String CODE_VERSION_KEY = "cVK";
        public static final String METADATA_VERSION_KEY = "mVK";
        public static final String BLACKLIST_VERSION_KEY = "bVK";
        public static final String DEVICE_KEY = "dK";
        public static final String SESSION_ID = "sId";
        public static final String APP_VERSION = "aV";
        public static final String SDK_VERSION = "sV";
        public static final String PLATFORM = "dM";
        public static final String CARRIER = "cA";
        public static final String LAST_SYNC_TIME = "lST";
        public static final String BUILD_TIME = "b";
        public static final String CPU_COUNT = "c";
        public static final String MAX_MEMORY = "m";
        public static final String OS_VERSION = "oV";
        public static final String APP_PACKAGE_NAME = "pN";
        public static final String STATS_KEY = "s";
        public static final String COUNTRY_OVERRIDE = "co";
        public static final String CONFIG_ADS_DISABLED = "cAdD";
        public static final String CONFIG_GAID_DISABLED = "cGD";
        public static final String CONFIG_USAGE_DISABLED = "cUD";
        public static final String CONFIG_SEARCH_ADS_DISABLED = "cSA";
        public static final String CONFIG_SEARCH_INSTALL_DISABLED = "cSI";
        public static final String CONFIG_REC_ADS_DISABLED = "cRA";
        public static final String CONFIG_REC_INSTALL_ADS_DISABLED = "cRI";
    }

    public static class RequestPath {
        public static final String SYNC = "sync";
        public static final String STATS = "stats";
    }

    public static class SyncParams {
        public static final String CODE = "c";
        public static final String ADS = "a";
        public static final String DELETE_ADS = "aD";
        public static final String UPDATE_ADS = "aUp";
        public static final String BLACKLIST_APPS = "b";
        public static final String SHORTCUTS = "s";
        public static final String DELETE_SHORTCUTS = "sD";
        public static final String ALIAS_LIST = "al";
        public static final String CONFIG = "cfg";
        public static final String REFRESH_INTERVAL = "rfI";
        public static final String LOCAL_REFRESH_INTERVAL = "lrfI";
        public static final String CONNECT_TIMEOUT = "cT";
        public static final String NETWORK_TIMEOUT = "nT";
        public static final String RETRY_INTERVAL = "rtI";
        public static final String RETRY_COUNT = "rC";
        public static final String VTA_ENABLED = "vta";
        public static final String INSTALL_ADS_ENABLED = "cpi";
        public static final String SEARCH_INSTALL_ADS_ENABLED = "scpi";
        public static final String SEARCH_ADS_ENABLED = "sad";
        public static final String RECOMMENDATION_INSTALL_ADS_ENABLED = "rcpi";
        public static final String RECOMMENDATION_ADS_ENABLED = "rad";
        public static final String WEB_ADS_ENABLED = "web";
        public static final String ORGANIC_ADS_ENABLED = "org";
        public static final String ORGANIC_ADS_BOOST_ENABLED = "orgB";
        public static final String ONLY_ORGANIC_ADS = "orgO";
        public static final String ADID_USAGE_ENABLED = "aId";
        public static final String APP_USAGE_DISABLED = "uD";
        public static final String AUTO_DEEP_LINK_ENABLED = "aDL";
        public static final String IMPRESSION_BLACKOUT_WINDOW = "iBW";
        public static final String AD_CACHE_TIME = "aCT";
        public static final String REPLACE_GOOGLE_PLAY_URL = "rGP";
        public static final String PLAY_STORE_REPLACEMENT_URL = "gpU";
        public static final String API_URL = "aU";
    }

    public static class UrlMacros {
        public static final String AD_ID = "{adId}";
        public static final String CLICK_ID = "{clickId}";
        public static final String APP_PACKAGE_NAME = "{packageName}";
        public static final String PRODUCT_SOURCE = "{productSource}";
    }
}